/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class CollectionUtils {
    public static <T> T genericCast(Object obj) {
        return (T)obj;
    }

    public static class Set {
        @SafeVarargs
        public static <T> java.util.Set<T> of(T ... elements) {
            if (elements != null) {
                LinkedHashSet set = new LinkedHashSet();
                Collections.addAll(set, elements);
                return set;
            }
            return Collections.emptySet();
        }
    }

    public static class Map {
        public static <K, V> java.util.Map<K, V> of(Object ... keyValuePairs) {
            if (keyValuePairs != null) {
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                for (int i = 0; i < keyValuePairs.length; i += 2) {
                    map.put(keyValuePairs[i], keyValuePairs[i + 1]);
                }
                return map;
            }
            return Collections.emptyMap();
        }
    }

    public static class List {
        @SafeVarargs
        public static <T> java.util.List<T> of(T ... elements) {
            return elements != null ? Arrays.asList(elements) : Collections.emptyList();
        }
    }
}

