/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.types.CLName;

public enum CLType {
    BOOL(0),
    I32(1),
    I64(2),
    U8(3),
    U32(4),
    U64(5),
    U128(6),
    U256(7),
    U512(8),
    UNIT(9),
    STRING(10),
    KEY(11),
    UREF(12),
    OPTION(13),
    LIST(14),
    BYTE_ARRAY(15),
    RESULT(16),
    MAP(17),
    TUPLE_1(18),
    TUPLE_2(19),
    TUPLE_3(20),
    ANY(21),
    PUBLIC_KEY(22);

    private final int clType;

    private CLType(int clType) {
        this.clType = clType;
    }

    public static CLType fromString(String jsonName) {
        for (CLType clType : CLType.values()) {
            if (!clType.getJsonName().equals(jsonName)) continue;
            return clType;
        }
        throw new IllegalArgumentException("Not a valid CLType json name " + jsonName);
    }

    public static boolean isNumeric(CLType clType) {
        switch (clType) {
            case I32: 
            case I64: 
            case U8: 
            case U32: 
            case U64: 
            case U128: 
            case U256: 
            case U512: {
                return true;
            }
        }
        return false;
    }

    public byte getClType() {
        return (byte)this.clType;
    }

    public String getJsonName() {
        try {
            CLName annotation = ((Object)((Object)this)).getClass().getField(this.name()).getAnnotation(CLName.class);
            if (annotation != null) {
                return annotation.value();
            }
            return this.name();
        }
        catch (NoSuchFieldException e) {
            throw new ConversionException(e);
        }
    }
}

