/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.signing;

import com.casper.sdk.exceptions.SignatureException;
import com.casper.sdk.service.signing.AbstractKeyPairBuilder;
import com.casper.sdk.types.Algorithm;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class Secp256k1KeyPairBuilder
extends AbstractKeyPairBuilder {
    public static final String CURVE_NAME = "secp256k1";
    public static final String ALGORITHM = "ECDSA";

    Secp256k1KeyPairBuilder() {
        super(Algorithm.SECP256K1);
    }

    @Override
    public KeyPair generateKeyPair() {
        return this.generateKeyPair(ALGORITHM, CURVE_NAME);
    }

    @Override
    public boolean isSupportedPublicKey(PublicKey publicKey) {
        return publicKey instanceof BCECPublicKey && ALGORITHM.equalsIgnoreCase(publicKey.getAlgorithm());
    }

    @Override
    public PublicKey createPublicKey(byte[] publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
            ECPoint point = ecSpec.getCurve().decodePoint(publicKey);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
            return keyFactory.generatePublic((KeySpec)pubSpec);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public byte[] convertFromDER(byte[] asn1EncodedSignature) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1EncodedSignature);
        BigInteger r = ((ASN1Integer)seq.getObjectAt(0)).getValue();
        BigInteger s = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        int n = (r.bitLength() + 7) / 8;
        n = Math.round((n + 1) / 2) * 2;
        byte[] out = new byte[2 * n];
        this.toFixed(r, out, 0, n);
        this.toFixed(s, out, n, n);
        return out;
    }

    @Override
    public byte[] convertToDER(byte[] p1363EncodedSignature) {
        int n = p1363EncodedSignature.length / 2;
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(p1363EncodedSignature, 0, n));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(p1363EncodedSignature, n, n * 2));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded();
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    private void toFixed(BigInteger x, byte[] a, int off, int len) {
        byte[] t = x.toByteArray();
        if (t.length == len + 1 && t[0] == 0) {
            System.arraycopy(t, 1, a, off, len);
        } else if (t.length <= len) {
            System.arraycopy(t, 0, a, off + len - t.length, t.length);
        } else {
            throw new SignatureException("Invalid length");
        }
    }
}

