/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.types.CLMapTypeInfo;
import com.casper.sdk.types.CLTypeInfo;
import com.casper.sdk.types.CLValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CLMap
extends CLValue
implements Map<CLValue, CLValue> {
    private final Map<CLValue, CLValue> map = new LinkedHashMap<CLValue, CLValue>();
    private boolean modified;

    public CLMap(String hexBytes, CLMapTypeInfo typeInfo, Object parsed) {
        this(CLMap.fromString(hexBytes), typeInfo, parsed);
    }

    public CLMap(byte[] bytes, CLMapTypeInfo typeInfo, Object parsed) {
        super(bytes, (CLTypeInfo)typeInfo, parsed);
        if (parsed instanceof Map) {
            this.map.putAll((Map)parsed);
        }
        this.modified = false;
    }

    @Override
    public CLValue put(CLValue key, CLValue value) {
        this.modified = true;
        return this.map.put(key, value);
    }

    @Override
    public CLValue remove(Object key) {
        this.modified = true;
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends CLValue, ? extends CLValue> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.modified = true;
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<CLValue> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<CLValue> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<CLValue, CLValue>> entrySet() {
        return this.map.entrySet();
    }

    @NotNull
    public Iterator<Map.Entry<CLValue, CLValue>> iterator() {
        return this.map.entrySet().iterator();
    }

    public CLTypeInfo getKeyType() {
        return ((CLMapTypeInfo)this.getCLTypeInfo()).getKeyType();
    }

    public CLTypeInfo getValueType() {
        return ((CLMapTypeInfo)this.getCLTypeInfo()).getValueType();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public CLValue get(Object key) {
        return this.map.get(key);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

