/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.service.serialization.util.TtlUtils;
import com.casper.sdk.types.CLPublicKey;
import com.casper.sdk.types.Digest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;

public class DeployHeader {
    private final CLPublicKey account;
    private final long timestamp;
    private final long ttl;
    @JsonProperty(value="gas_price")
    private final Integer gasPrice;
    @JsonProperty(value="body_hash")
    private final Digest bodyHash;
    private final List<Digest> dependencies;
    @JsonProperty(value="chain_name")
    private final String chainName;

    @JsonCreator
    public DeployHeader(@JsonProperty(value="account") CLPublicKey account, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="ttl") String ttl, @JsonProperty(value="gas_price", defaultValue="null") Integer gasPrice, @JsonProperty(value="body_hash") Digest bodyHash, @JsonProperty(value="dependencies") List<Digest> dependencies, @JsonProperty(value="chain_name") String chainName) {
        this(account, DeployHeader.toEpocMs(timestamp), TtlUtils.getTtlLong(ttl), gasPrice, bodyHash, dependencies, chainName);
    }

    public DeployHeader(CLPublicKey account, long timestamp, long ttl, Integer gasPrice, Digest bodyHash, List<Digest> dependencies, String chainName) {
        this.account = account;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.gasPrice = gasPrice;
        this.bodyHash = bodyHash;
        this.dependencies = dependencies;
        this.chainName = chainName;
    }

    public static long toEpocMs(String isoDateTime) {
        ZonedDateTime zonedDateTime = OffsetDateTime.parse(isoDateTime).toZonedDateTime();
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public CLPublicKey getAccount() {
        return this.account;
    }

    @JsonIgnore
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public String getTimeStampIso() {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(this.timestamp).atZone(ZoneId.from(ZoneOffset.UTC));
        return zonedDateTime.toString();
    }

    @JsonIgnore
    public long getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="ttl")
    public String getTtlStr() {
        return TtlUtils.toTtlStr(this.ttl);
    }

    public Integer getGasPrice() {
        return this.gasPrice;
    }

    public Digest getBodyHash() {
        return this.bodyHash;
    }

    public List<Digest> getDependencies() {
        return this.dependencies;
    }

    public String getChainName() {
        return this.chainName;
    }
}

