/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.serialize;

import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLKeyInfo;
import com.casper.sdk.types.CLKeyValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CLKeyValueJsonSerializer
extends JsonSerializer<CLKeyValue> {
    public void serialize(CLKeyValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("cl_type");
        gen.getCodec().writeValue(gen, (Object)value.getCLTypeInfo());
        gen.writeFieldName("bytes");
        gen.writeString(this.buildJsonBytes(value));
        this.writeParsed(value, gen);
        gen.writeEndObject();
    }

    @NotNull
    private String buildJsonBytes(CLKeyValue value) {
        return this.getValueBytes(value);
    }

    protected String getValueBytes(CLKeyValue value) {
        return value.toHex();
    }

    private void writeParsed(CLKeyValue value, JsonGenerator gen) throws IOException {
        String strParsed = value.getParsed() != null ? this.buildParsed(value.getParsed().toString(), value.getKeyType()) : (value.getKeyBytes() != null ? this.buildParsed(ByteUtils.encodeHexString(value.getKeyBytes()), value.getKeyType()) : null);
        if (strParsed != null) {
            gen.writeFieldName("parsed");
            gen.writeStartObject();
            gen.writeFieldName("Hash");
            gen.writeString(strParsed);
            gen.writeEndObject();
        }
    }

    private String buildParsed(String parsed, CLKeyInfo.KeyType keyType) {
        if (parsed.contains("-")) {
            return parsed;
        }
        return keyType.getParsedName() + "-" + parsed;
    }
}

