/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLMap;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLValue;
import java.util.Map;

public class MapSerializer
implements TypesSerializer {
    final TypesFactory typesFactory;

    public MapSerializer(TypesFactory typesFactory) {
        this.typesFactory = typesFactory;
    }

    @Override
    public byte[] serialize(Object toSerialize) {
        if (toSerialize instanceof CLMap) {
            if (((CLMap)toSerialize).isModified() || ((CLMap)toSerialize).getBytes() == null) {
                ((CLMap)toSerialize).setModified(false);
                return ByteUtils.concat(this.typesFactory.getInstance(CLType.U32).serialize(((CLMap)toSerialize).size()), this.buildMapBytes((CLMap)toSerialize));
            }
            return ((CLMap)toSerialize).getBytes();
        }
        return new byte[0];
    }

    private byte[] buildMapBytes(CLMap clMap) {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        for (Map.Entry<CLValue, CLValue> entry : clMap.entrySet()) {
            builder.append(entry.getKey().getBytes());
            builder.append(entry.getValue().getBytes());
        }
        return builder.toByteArray();
    }
}

