/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializerFactory;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.DeployNamedArg;
import com.casper.sdk.types.ModuleBytes;
import com.casper.sdk.types.StoredContractByHash;
import com.casper.sdk.types.StoredContractByName;
import java.util.List;

class DeployExecutableByteSerializer
implements ByteSerializer<DeployExecutable> {
    private final ByteSerializerFactory factory;
    private final TypesSerializer byteArraySerializer;
    private final TypesSerializer stringSerializer;
    private final TypesSerializer u32Serializer;

    public DeployExecutableByteSerializer(ByteSerializerFactory factory, TypesFactory typesFactory) {
        this.factory = factory;
        this.byteArraySerializer = typesFactory.getInstance(CLType.BYTE_ARRAY);
        this.stringSerializer = typesFactory.getInstance(CLType.STRING);
        this.u32Serializer = typesFactory.getInstance(CLType.U32);
    }

    @Override
    public Class<DeployExecutable> getType() {
        return DeployExecutable.class;
    }

    @Override
    public byte[] toBytes(DeployExecutable deployExecutable) {
        ByteArrayBuilder builder = new ByteArrayBuilder().append((byte)deployExecutable.getTag());
        if (deployExecutable instanceof StoredContractByName) {
            builder.append(this.stringSerializer.serialize(((StoredContractByName)deployExecutable).getName())).append(this.stringSerializer.serialize(((StoredContractByName)deployExecutable).getEntryPoint()));
        } else if (deployExecutable instanceof StoredContractByHash) {
            builder.append(((StoredContractByHash)deployExecutable).getHash().getHash());
            builder.append(this.stringSerializer.serialize(((StoredContractByHash)deployExecutable).getEntryPoint()));
        } else if (deployExecutable instanceof ModuleBytes) {
            builder.append(this.byteArraySerializer.serialize(deployExecutable.getModuleBytes()));
        }
        builder.append(this.toBytes(deployExecutable.getArgs()));
        return builder.toByteArray();
    }

    @Override
    private byte[] toBytes(List<DeployNamedArg> args) {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        builder.append(this.u32Serializer.serialize(args.size()));
        args.forEach(deployNamedArg -> builder.append(this.factory.getByteSerializer(deployNamedArg).toBytes((DeployNamedArg)deployNamedArg)));
        return builder.toByteArray();
    }
}

