/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json;

import com.casper.sdk.service.json.deserialize.DeserializerContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JsonConversionService {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonConversionService() {
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        this.mapper.writer((PrettyPrinter)prettyPrinter);
    }

    public String toJson(Object clObject) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toJson(clObject, out);
        return ((Object)out).toString();
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        return this.mapper.writeValueAsString(value);
    }

    public void toJson(Object clObject, OutputStream out) throws IOException {
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        this.mapper.writer((PrettyPrinter)prettyPrinter).writeValue(out, clObject);
        out.close();
    }

    public <T> T fromJson(String json, Class<T> type) throws IOException {
        DeserializerContext.clear();
        return (T)this.mapper.reader().readValue(json, type);
    }

    public <T> T fromJson(InputStream in, Class<T> type) throws IOException {
        DeserializerContext.clear();
        return (T)this.mapper.reader().readValue(in, type);
    }
}

