/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.serialize;

import com.casper.sdk.types.CLValue;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.ModuleBytes;
import com.casper.sdk.types.StoredContractByHash;
import com.casper.sdk.types.StoredContractByName;
import com.casper.sdk.types.StoredVersionedContractByHash;
import com.casper.sdk.types.StoredVersionedContractByName;
import com.casper.sdk.types.Transfer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class DeployExecutableJsonSerializer
extends JsonSerializer<DeployExecutable> {
    public void serialize(DeployExecutable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value instanceof Transfer) {
            this.writeTransfer((Transfer)value, gen);
        } else if (value instanceof StoredVersionedContractByHash) {
            this.writeStoredVersionedContractByHash((StoredVersionedContractByHash)value, gen);
        } else if (value instanceof StoredContractByHash) {
            this.writeStoredContractByHash((StoredContractByHash)value, gen);
        } else if (value instanceof StoredVersionedContractByName) {
            this.writeStoredVersionedContractByName((StoredVersionedContractByName)value, gen);
        } else if (value instanceof StoredContractByName) {
            this.writeStoredContractByName((StoredContractByName)value, gen);
        } else if (value instanceof ModuleBytes) {
            this.writePayment((ModuleBytes)value, gen);
        } else {
            this.writeArgs(value, gen);
        }
    }

    private void writePayment(ModuleBytes payment, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("ModuleBytes");
        gen.writeStartObject();
        gen.writeFieldName("module_bytes");
        gen.writeString(CLValue.toHex(payment.getModuleBytes()));
        this.writeArgs(payment, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeStoredContractByHash(StoredContractByHash storedContractByHash, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("StoredContractByHash");
        gen.writeStartObject();
        gen.writeFieldName("hash");
        gen.writeString(storedContractByHash.getHash().toString());
        gen.writeFieldName("entry_point");
        gen.writeString(storedContractByHash.getEntryPoint());
        this.writeArgs(storedContractByHash, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeStoredVersionedContractByHash(StoredVersionedContractByHash storedVersionedContractByHash, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("StoredVersionedContractByHash");
        gen.writeStartObject();
        gen.writeFieldName("hash");
        gen.writeString(storedVersionedContractByHash.getHash().toString());
        if (storedVersionedContractByHash.getVersion().isPresent()) {
            gen.writeFieldName("version");
            gen.writeNumber(storedVersionedContractByHash.getVersion().get().longValue());
        }
        gen.writeFieldName("entry_point");
        gen.writeString(storedVersionedContractByHash.getEntryPoint());
        this.writeArgs(storedVersionedContractByHash, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeStoredContractByName(StoredContractByName storedContractByName, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("StoredContractByName");
        gen.writeStartObject();
        gen.writeFieldName("name");
        gen.writeString(storedContractByName.getName());
        gen.writeFieldName("entry_point");
        gen.writeString(storedContractByName.getEntryPoint());
        this.writeArgs(storedContractByName, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeStoredVersionedContractByName(StoredVersionedContractByName storedVersionedContractByName, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("StoredVersionedContractByName");
        gen.writeStartObject();
        gen.writeFieldName("name");
        gen.writeString(storedVersionedContractByName.getName());
        if (storedVersionedContractByName.getVersion().isPresent()) {
            gen.writeFieldName("version");
            gen.writeNumber(storedVersionedContractByName.getVersion().get().longValue());
        }
        gen.writeFieldName("entry_point");
        gen.writeString(storedVersionedContractByName.getEntryPoint());
        this.writeArgs(storedVersionedContractByName, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeTransfer(Transfer transfer, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("Transfer");
        gen.writeStartObject();
        this.writeArgs(transfer, gen);
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private void writeArgs(DeployExecutable value, JsonGenerator gen) throws IOException {
        gen.writeFieldName("args");
        gen.getCodec().writeValue(gen, value.getArgs());
    }
}

