/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.exceptions.ValueNotFoundException;
import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLByteArrayInfo;
import com.casper.sdk.types.CLKeyInfo;
import com.casper.sdk.types.CLKeyValue;
import com.casper.sdk.types.CLMap;
import com.casper.sdk.types.CLMapTypeInfo;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;
import com.casper.sdk.types.CLValue;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class CLValueBuilder {
    private static final TypesFactory TYPES_FACTORY = new TypesFactory();

    public static CLValue bool(Object value) {
        return CLValueBuilder.buildCLValue(CLType.BOOL, value);
    }

    public static CLValue byteArray(Object value) {
        byte[] bytes = TYPES_FACTORY.getInstance(CLType.BYTE_ARRAY).serialize(value);
        return new CLValue(bytes, (CLTypeInfo)new CLByteArrayInfo(CLValueBuilder.getArrayLength(bytes)), value);
    }

    public static CLValue i32(Object value) {
        return CLValueBuilder.buildCLValue(CLType.I32, value);
    }

    public static CLValue i64(Object value) {
        return CLValueBuilder.buildCLValue(CLType.I64, value);
    }

    public static CLValue string(Object value) {
        return CLValueBuilder.buildCLValue(CLType.STRING, value);
    }

    public static CLValue u8(Object value) {
        return CLValueBuilder.buildCLValue(CLType.U8, value);
    }

    public static CLValue u32(Object value) {
        return CLValueBuilder.buildCLValue(CLType.U32, value);
    }

    public static CLValue u64(Object value) {
        return CLValueBuilder.buildCLValue(CLType.U64, value);
    }

    public static CLValue u256(Object value) {
        return CLValueBuilder.buildCLValue(CLType.U256, value);
    }

    public static CLValue u512(Object value) {
        return CLValueBuilder.buildCLValue(CLType.U512, value);
    }

    public static CLKeyValue key(byte[] value) {
        if (value.length != 33) {
            throw new ConversionException("Missing key type from byte array");
        }
        return new CLKeyValue(ByteUtils.lastNBytes(value, 32), CLKeyInfo.KeyType.valueOf(value[0]), null);
    }

    public static CLKeyValue accountKey(byte[] value) {
        return CLValueBuilder.key(ByteUtils.concat(ByteUtils.toByteArray(CLKeyInfo.KeyType.ACCOUNT_ID.getTag()), value));
    }

    public static CLKeyValue hashKey(byte[] value) {
        return CLValueBuilder.key(ByteUtils.concat(ByteUtils.toByteArray(CLKeyInfo.KeyType.HASH_ID.getTag()), value));
    }

    public static CLValue publicKey(PublicKey publicKey) {
        return CLValueBuilder.buildCLValue(CLType.PUBLIC_KEY, publicKey);
    }

    public static CLKeyValue uRefKey(byte[] value) {
        return CLValueBuilder.key(ByteUtils.concat(ByteUtils.toByteArray(CLKeyInfo.KeyType.UREF_ID.getTag()), value));
    }

    public static CLMap map(Map<CLValue, CLValue> map) {
        if (map.isEmpty()) {
            throw new ValueNotFoundException("Maps must contain at least one key pair");
        }
        return new CLMap(TYPES_FACTORY.getInstance(CLType.MAP).serialize(map), new CLMapTypeInfo(map.keySet().iterator().next().getCLTypeInfo(), map.values().iterator().next().getCLTypeInfo()), map);
    }

    public static CLValue buildCLValue(CLType type, Object value) {
        return new CLValue(TYPES_FACTORY.getInstance(type).serialize(value), type, value);
    }

    private static int getArrayLength(byte[] bytes) {
        if (bytes != null && bytes.length > 3) {
            byte[] u32Len = new byte[4];
            System.arraycopy(bytes, 0, u32Len, 0, 4);
            ArrayUtils.reverse((byte[])u32Len);
            return new BigInteger(u32Len).intValue();
        }
        return 0;
    }
}

