/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.util;

import com.casper.sdk.exceptions.ConversionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ByteArrayBuilder {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    private static byte[] decodeHex(String serialize) {
        try {
            return Hex.decodeHex((char[])serialize.toCharArray());
        }
        catch (DecoderException e) {
            throw new ConversionException("Unable to decode " + serialize, e);
        }
    }

    public ByteArrayBuilder append(byte[] bytes) {
        try {
            if (bytes != null && bytes.length > 0) {
                this.out.write(bytes);
            }
            return this;
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    public ByteArrayBuilder append(byte aByte) {
        this.out.write(aByte);
        return this;
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }
}

