/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.deserialize;

import com.casper.sdk.service.json.deserialize.DeserializerContext;
import com.casper.sdk.types.Deploy;
import com.casper.sdk.types.DeployApproval;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.DeployHeader;
import com.casper.sdk.types.Digest;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Set;

public class DeployJsonDeserializer
extends JsonDeserializer<Deploy> {
    public Deploy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = p.getCodec();
        TreeNode treeNode = codec.readTree(p);
        TreeNode deployNode = treeNode.get("deploy");
        if (deployNode != null) {
            treeNode = codec.readTree(deployNode.traverse());
        }
        return this.deserializeDeploy(treeNode, codec);
    }

    private Deploy deserializeDeploy(TreeNode treeNode, ObjectCodec codec) throws IOException {
        return new Deploy(this.readChildNode(treeNode, codec, "hash", Digest.class), this.readChildNode(treeNode, codec, "header", DeployHeader.class), this.readChildNode(treeNode, codec, "payment", DeployExecutable.class), this.readChildNode(treeNode, codec, "session", DeployExecutable.class), this.readChildNode(treeNode, codec, "approvals", new TypeReference<Set<DeployApproval>>(){}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readChildNode(TreeNode digestNode, ObjectCodec codec, String name, Class<T> type) throws IOException {
        try {
            DeserializerContext.pushFieldName(name);
            TreeNode child = digestNode.get(name);
            if (child != null) {
                JsonParser childParser = child.traverse();
                if (childParser.getCodec() == null) {
                    childParser.setCodec(codec);
                }
                Object object = codec.readValue(childParser, type);
                return (T)object;
            }
        }
        finally {
            DeserializerContext.popFieldName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readChildNode(TreeNode digestNode, ObjectCodec codec, String name, TypeReference<T> type) throws IOException {
        try {
            DeserializerContext.pushFieldName(name);
            TreeNode child = digestNode.get(name);
            if (child != null) {
                JsonParser childParser = child.traverse();
                if (childParser.getCodec() == null) {
                    childParser.setCodec(codec);
                }
                Object object = codec.readValue(childParser, type);
                return (T)object;
            }
        }
        finally {
            DeserializerContext.popFieldName();
        }
        return null;
    }
}

