/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.util.ByteUtils;

class U8Serializer
implements TypesSerializer {
    U8Serializer() {
    }

    @Override
    public byte[] serialize(Object toSerialize) {
        if (toSerialize instanceof Byte) {
            return new byte[]{(Byte)toSerialize};
        }
        if (toSerialize instanceof Number) {
            if (((Number)toSerialize).shortValue() > 255) {
                throw new IllegalArgumentException("Not a valid byte " + toSerialize);
            }
            return this.serialize(((Number)toSerialize).byteValue());
        }
        if (toSerialize instanceof String && ((String)toSerialize).length() == 2) {
            return ByteUtils.decodeHex((String)toSerialize);
        }
        throw new IllegalArgumentException("Not a valid byte " + toSerialize);
    }
}

