/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.service.hash.HashService;
import com.casper.sdk.service.json.JsonConversionService;
import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializerFactory;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.service.serialization.util.CollectionUtils;
import com.casper.sdk.service.serialization.util.NumberUtils;
import com.casper.sdk.service.signing.SigningService;
import com.casper.sdk.types.CLByteArrayInfo;
import com.casper.sdk.types.CLOptionTypeInfo;
import com.casper.sdk.types.CLOptionValue;
import com.casper.sdk.types.CLPublicKey;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;
import com.casper.sdk.types.CLValue;
import com.casper.sdk.types.Deploy;
import com.casper.sdk.types.DeployApproval;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.DeployHeader;
import com.casper.sdk.types.DeployNamedArg;
import com.casper.sdk.types.DeployParams;
import com.casper.sdk.types.Digest;
import com.casper.sdk.types.ModuleBytes;
import com.casper.sdk.types.Signature;
import com.casper.sdk.types.Transfer;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;

public class DeployService {
    private final ByteSerializerFactory serializerFactory;
    private final HashService hashService;
    private final JsonConversionService jsonService;
    private final SigningService signingService;
    private final TypesSerializer u64Serializer;
    private final TypesSerializer u512Serializer;

    public DeployService(ByteSerializerFactory serializerFactory, HashService hashService, JsonConversionService jsonService, SigningService signingService, TypesFactory typesFactory) {
        this.serializerFactory = serializerFactory;
        this.hashService = hashService;
        this.jsonService = jsonService;
        this.signingService = signingService;
        this.u64Serializer = typesFactory.getInstance(CLType.U64);
        this.u512Serializer = typesFactory.getInstance(CLType.U512);
    }

    String toTtlStr(long ttl) {
        return Duration.ofMillis(ttl).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public byte[] toBytes(Deploy deploy) {
        return this.serializerFactory.getByteSerializer(deploy).toBytes(deploy);
    }

    byte[] serializedHeader(DeployHeader header) {
        return this.serializerFactory.getByteSerializerByType(DeployHeader.class).toBytes(header);
    }

    byte[] serializeBody(DeployExecutable payment, DeployExecutable session) {
        return ByteUtils.concat(this.toBytes(payment), this.toBytes(session));
    }

    byte[] serializeApprovals(Set<DeployApproval> approvals) {
        return this.serializerFactory.getByteSerializerByType(Set.class).toBytes(approvals);
    }

    public Deploy makeDeploy(DeployParams deployParams, DeployExecutable session, DeployExecutable payment) {
        Digest bodyHash = this.makeBodyHash(session, payment);
        DeployHeader header = new DeployHeader(this.signingService.toClPublicKey((PublicKey)deployParams.getAccountKey()), deployParams.getTimestamp(), this.toTtlStr(deployParams.getTtl()), (Integer)deployParams.getGasPrice(), bodyHash, deployParams.getDependencies(), deployParams.getChainName());
        byte[] serializedHeader = this.serializedHeader(header);
        Digest deployHash = new Digest(this.hashService.getHash(serializedHeader));
        return new Deploy(deployHash, header, payment, session, new LinkedHashSet<DeployApproval>());
    }

    Digest makeBodyHash(DeployExecutable session, DeployExecutable payment) {
        byte[] serializedBody = this.serializeBody(payment, session);
        byte[] hash = this.hashService.getHash(serializedBody);
        return new Digest(hash);
    }

    public Transfer newTransfer(Number amount, CLPublicKey target, Number id) {
        byte[] amountBytes = this.u512Serializer.serialize(amount);
        byte[] idBytes = CLOptionValue.prefixOption(this.u64Serializer.serialize(id));
        String accountKey = target.toAccountHex();
        String accountHash = this.hashService.getAccountHash(accountKey);
        DeployNamedArg amountArg = new DeployNamedArg("amount", new CLValue(amountBytes, CLType.U512, (Object)amount.toString()));
        DeployNamedArg targetArg = new DeployNamedArg("target", new CLValue(accountHash, (CLTypeInfo)new CLByteArrayInfo(32), (Object)target.toAccountHex()));
        DeployNamedArg idArg = new DeployNamedArg("id", new CLOptionValue(idBytes, new CLOptionTypeInfo(new CLTypeInfo(CLType.U64)), (Object)id.toString()));
        return new Transfer(CollectionUtils.List.of(amountArg, targetArg, idArg));
    }

    public ModuleBytes standardPayment(Number paymentAmount) {
        BigInteger biAmount = NumberUtils.toBigInteger(paymentAmount);
        byte[] amountBytes = this.u512Serializer.serialize(biAmount);
        DeployNamedArg paymentArg = new DeployNamedArg("amount", new CLValue(amountBytes, CLType.U512, (Object)paymentAmount));
        return new ModuleBytes(new byte[0], CollectionUtils.List.of(paymentArg));
    }

    public Deploy fromJson(String json) {
        try {
            return this.jsonService.fromJson(json, Deploy.class);
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    public Deploy fromJson(InputStream in) {
        try {
            return this.jsonService.fromJson(in, Deploy.class);
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    public int deploySizeInBytes(Deploy deploy) {
        return this.toBytes(deploy).length;
    }

    byte[] toBytes(DeployExecutable deployExecutable) {
        return this.serializerFactory.getByteSerializer(deployExecutable).toBytes(deployExecutable);
    }

    public Deploy signDeploy(Deploy deploy, KeyPair keyPair) {
        byte[] signed = this.signingService.signWithPrivateKey(keyPair.getPrivate(), deploy.getHash().getHash());
        CLPublicKey publicKey = this.signingService.toClPublicKey(keyPair.getPublic());
        deploy.getApprovals().add(new DeployApproval(publicKey, new Signature(signed, publicKey.getAlgorithm())));
        return deploy;
    }
}

