/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.http.rpc;

import com.casper.sdk.exceptions.ValueNotFoundException;
import com.casper.sdk.service.hash.HashService;
import com.casper.sdk.service.http.rpc.HttpMethods;
import com.casper.sdk.service.http.rpc.Method;
import com.casper.sdk.service.http.rpc.MethodEnums;
import com.casper.sdk.service.serialization.util.CollectionUtils;
import com.casper.sdk.types.Deploy;
import com.casper.sdk.types.DeployService;
import com.casper.sdk.types.Digest;
import com.casper.sdk.types.URef;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class NodeClient {
    public static final String DEPLOY_TOO_LARGE_MSG = "Deploy can not be send, because it's too large: %d bytes. Max size is 1 megabyte.";
    private static final int ONE_MEGABYTE = 0x100000;
    private static final String HASH = "Hash";
    private final HttpMethods httpMethods;
    private final HashService hashService;
    private final DeployService deployService;

    public NodeClient(DeployService deployService, HashService hashService, HttpMethods httpMethods) {
        this.deployService = deployService;
        this.hashService = hashService;
        this.httpMethods = httpMethods;
    }

    public String getStateRootHash() {
        return this.rcpCallMethodMap(new Method("chain_get_state_root_hash"), MethodEnums.STATE_ROOT_HASH::getValue);
    }

    public String getAccountInfo(String accountKey) {
        return this.rcpCallMethodMap(new Method("state_get_item", CollectionUtils.Map.of("state_root_hash", this.getStateRootHash(), "key", "account-hash-" + this.hashService.getAccountHash(accountKey), "path", Collections.emptyList())), MethodEnums.ACCOUNT_INFO::getValue);
    }

    public BigInteger getAccountBalance(String accountKey) {
        return this.rcpCallMethodMap(new Method("state_get_balance", CollectionUtils.Map.of("state_root_hash", this.getStateRootHash(), "purse_uref", this.getAccountMainPurseURef(accountKey).toString())), result -> new BigInteger(MethodEnums.STATE_GET_BALANCE.getValue((String)result)));
    }

    public URef getAccountMainPurseURef(String accountKey) {
        return this.rcpCallMethodMap(new Method("state_get_item", CollectionUtils.Map.of("key", "account-hash-" + this.hashService.getAccountHash(accountKey), "state_root_hash", this.getStateRootHash(), "path", Collections.emptyList())), result -> new URef(MethodEnums.STATE_GET_ITEM.getValue((String)result)));
    }

    public String getAuctionInfo() {
        return this.rcpCallMethodMap(new Method("state_get_auction_info", new HashMap<String, Object>()), MethodEnums.STATE_GET_AUCTION_INFO::getValue);
    }

    public String getNodePeers() {
        return this.rcpCallMethodMap(new Method("info_get_peers", new HashMap<String, Object>()), MethodEnums.INFO_GET_PEERS::getValue);
    }

    public String getNodeStatus() {
        return this.rcpCallMethodMap(new Method("info_get_status", new HashMap<String, Object>()), MethodEnums.INFO_GET_STATUS::getValue);
    }

    public String putDeploy(Deploy signedDeploy) {
        int size = this.deployService.deploySizeInBytes(signedDeploy);
        if (size > 0x100000) {
            throw new IllegalArgumentException(String.format(DEPLOY_TOO_LARGE_MSG, size));
        }
        return this.rcpCallMethodMap(new Method("account_put_deploy", CollectionUtils.Map.of("deploy", signedDeploy)), MethodEnums.ACCOUNT_PUT_DEPLOY::getValue);
    }

    public Deploy getDeploy(Digest deployHash) {
        return this.rcpCallMethodMap(new Method("info_get_deploy", CollectionUtils.Map.of("deploy_hash", deployHash.toString())), result -> this.deployService.fromJson(MethodEnums.INFO_GET_DEPLOY.getValue((String)result)));
    }

    public String getLatestBlockInfo() {
        return this.getChainBlockInfo(new HashMap<String, Object>());
    }

    public String getBlockInfo(Digest blockHash) {
        Map<String, Object> params = CollectionUtils.Map.of("block_identifier", CollectionUtils.Map.of(HASH, blockHash.toString()));
        return this.getChainBlockInfo(params);
    }

    public String getBlockInfoByHeight(Number height) {
        Map<String, Object> params = CollectionUtils.Map.of("block_identifier", CollectionUtils.Map.of("Height", height.toString()));
        return this.getChainBlockInfo(params);
    }

    String getChainBlockInfo(Map<String, Object> params) {
        return this.rcpCallMethodMap(new Method("chain_get_block", params), MethodEnums.CHAIN_GET_BLOCK::getValue);
    }

    public String getRpcSchema() {
        return this.rcpCallMethodMap(new Method("rpc.discover", new HashMap<String, Object>()), MethodEnums.RPC_DISCOVER::getValue);
    }

    public String getBlockTransfers() {
        return this.rcpCallMethodMap(new Method("chain_get_block_transfers", new HashMap<String, Object>()), MethodEnums.CHAIN_GET_BLOCK_TRANSFERS::getValue);
    }

    public String getEraInfoBySwitchBlock() {
        return this.rcpCallMethodMap(new Method("chain_get_era_info_by_switch_block", new HashMap<String, Object>()), MethodEnums.CHAIN_GET_ERA_INFO_BY_SWITCH_BLOCK::getValue);
    }

    private <T> T rcpCallMethodMap(Method method, Function<String, ? extends T> mapper) {
        return this.httpMethods.rpcCallMethod(method).map(mapper).orElseThrow(() -> new ValueNotFoundException("For " + method));
    }
}

