/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLMap;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLValue;
import java.util.Map;

public class MapSerializer
implements TypesSerializer {
    final TypesFactory typesFactory;

    public MapSerializer(TypesFactory typesFactory) {
        this.typesFactory = typesFactory;
    }

    @Override
    public byte[] serialize(Object toSerialize) {
        if (toSerialize instanceof CLMap) {
            if (this.isModifiedOrNotYetSerialized((CLMap)toSerialize)) {
                ((CLMap)toSerialize).setModified(false);
                return this.serializeMap((Map)toSerialize);
            }
            return ((CLMap)toSerialize).getBytes();
        }
        if (toSerialize instanceof Map) {
            return this.serializeMap((Map)toSerialize);
        }
        return new byte[0];
    }

    private boolean isModifiedOrNotYetSerialized(CLMap toSerialize) {
        return toSerialize.isModified() || toSerialize.getBytes() == null;
    }

    private byte[] serializeMap(Map<CLValue, CLValue> toSerialize) {
        return ByteUtils.concat(this.typesFactory.getInstance(CLType.U32).serialize(toSerialize.size()), this.buildKeyValueBytes(toSerialize));
    }

    private byte[] buildKeyValueBytes(Map<CLValue, CLValue> clMap) {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        for (Map.Entry<CLValue, CLValue> entry : clMap.entrySet()) {
            builder.append(entry.getKey().getBytes());
            builder.append(entry.getValue().getBytes());
        }
        return builder.toByteArray();
    }
}

