/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.signing;

import com.casper.sdk.exceptions.SignatureException;
import com.casper.sdk.service.signing.Ed25519KeyPariBuilder;
import com.casper.sdk.service.signing.KeyPairBuilder;
import com.casper.sdk.service.signing.Secp256k1KeyPairBuilder;
import com.casper.sdk.types.Algorithm;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class KeyPairFactory {
    private final Map<Algorithm, KeyPairBuilder> keyPairBuilderMap = new HashMap<Algorithm, KeyPairBuilder>();

    public KeyPairFactory() {
        this.registerSigner(new Ed25519KeyPariBuilder());
        this.registerSigner(new Secp256k1KeyPairBuilder());
    }

    void registerSigner(KeyPairBuilder signer) {
        this.keyPairBuilderMap.put(signer.getAlgorithm(), signer);
    }

    KeyPairBuilder getKeyPairBuilder(Algorithm algorithm) {
        return this.keyPairBuilderMap.get((Object)algorithm);
    }

    public KeyPairBuilder getKeyPairBuilderForPublicKey(PublicKey publicKey) {
        for (KeyPairBuilder keyPairBuilder : this.keyPairBuilderMap.values()) {
            if (!keyPairBuilder.isSupportedPublicKey(publicKey)) continue;
            return keyPairBuilder;
        }
        throw new SignatureException("Unsupported PublicKey " + publicKey);
    }

    public KeyPairBuilder getKeyPairBuilder(String algorithm) {
        return this.getKeyPairBuilder(Algorithm.fromString(algorithm));
    }
}

