/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.service.json.deserialize.DeployJsonDeserializer;
import com.casper.sdk.types.DeployApproval;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.DeployHeader;
import com.casper.sdk.types.Digest;
import com.casper.sdk.types.Transfer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonDeserialize(using=DeployJsonDeserializer.class)
public class Deploy {
    private final Digest hash;
    private final DeployHeader header;
    private final DeployExecutable payment;
    private final DeployExecutable session;
    private final Set<DeployApproval> approvals;

    @JsonCreator
    public Deploy(@JsonProperty(value="hash") Digest hash, @JsonProperty(value="header") DeployHeader header, @JsonProperty(value="payment") DeployExecutable payment, @JsonProperty(value="session") DeployExecutable session, @JsonProperty(value="approvals") Set<DeployApproval> approvals) {
        this.hash = hash;
        this.header = header;
        this.payment = payment;
        this.session = session;
        this.approvals = approvals != null ? approvals : new LinkedHashSet();
    }

    public Digest getHash() {
        return this.hash;
    }

    public DeployHeader getHeader() {
        return this.header;
    }

    public <P extends DeployExecutable> P getPayment() {
        return (P)this.payment;
    }

    public <T extends DeployExecutable> T getSession() {
        return (T)this.session;
    }

    public Set<DeployApproval> getApprovals() {
        return this.approvals;
    }

    @JsonIgnore
    public boolean isTransfer() {
        return this.getSession() instanceof Transfer;
    }
}

