/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.http.rpc;

import com.casper.sdk.exceptions.ValueNotFoundException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public enum MethodEnums {
    ACCOUNT_INFO{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).toPrettyString();
            }
            catch (JsonProcessingException e) {
                throw new ValueNotFoundException("state root hash not found");
            }
        }
    }
    ,
    ACCOUNT_PUT_DEPLOY{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                JsonNode resultNode = this.getResultNode(result);
                return resultNode.get("deploy_hash").textValue();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("deploy_hash not found " + this.buildErrorMessage(result));
            }
        }
    }
    ,
    CHAIN_GET_BLOCK{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).get("block").toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("block not found");
            }
        }
    }
    ,
    CHAIN_GET_BLOCK_TRANSFERS{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("result not found");
            }
        }
    }
    ,
    CHAIN_GET_ERA_INFO_BY_SWITCH_BLOCK{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("result not found");
            }
        }
    }
    ,
    INFO_GET_DEPLOY{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            JsonNode resultNode = null;
            try {
                resultNode = this.getResultNode(result);
                return resultNode.get("deploy").toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("deploy not found " + this.buildErrorMessage(resultNode));
            }
        }
    }
    ,
    INFO_GET_PEERS{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("peers not found");
            }
        }
    }
    ,
    INFO_GET_STATUS{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("result not found");
            }
        }
    }
    ,
    RPC_DISCOVER{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("result not found");
            }
        }
    }
    ,
    STATE_GET_BALANCE{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).get("balance_value").textValue();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("balance_value not found");
            }
        }
    }
    ,
    STATE_GET_ITEM{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            JsonNode resultNode = null;
            try {
                resultNode = this.getResultNode(result);
                return resultNode.get("stored_value").get("Account").get("main_purse").textValue();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("main_purse not found " + this.buildErrorMessage(resultNode));
            }
        }
    }
    ,
    STATE_GET_AUCTION_INFO{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).toPrettyString();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("auction_state not found");
            }
        }
    }
    ,
    STATE_ROOT_HASH{

        @Override
        public String getValue(String result) throws ValueNotFoundException {
            try {
                return this.getResultNode(result).get("state_root_hash").textValue();
            }
            catch (Exception e) {
                throw new ValueNotFoundException("state root hash not found");
            }
        }
    };


    abstract String getValue(String var1) throws ValueNotFoundException;

    JsonNode getResultNode(String result) throws JsonProcessingException {
        JsonNode node = new ObjectMapper().readTree(result);
        return node.get("result");
    }

    String buildErrorMessage(String result) {
        try {
            JsonNode error;
            JsonNode node = new ObjectMapper().readTree(result);
            JsonNode jsonNode = error = node != null ? node.get("error") : null;
            if (error != null) {
                return error.toString();
            }
            return "";
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    String buildErrorMessage(JsonNode node) {
        JsonNode error;
        JsonNode jsonNode = error = node != null ? node.get("error") : null;
        if (error != null) {
            return error.toString();
        }
        return "";
    }
}

