/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializerFactory;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.service.serialization.util.CollectionUtils;
import com.casper.sdk.types.CLType;
import java.util.Collection;

class CollectionByteSerializer
implements ByteSerializer<Collection<?>> {
    private final ByteSerializerFactory factory;
    private final TypesSerializer u32Serializer;

    public CollectionByteSerializer(ByteSerializerFactory factory, TypesFactory typesFactory) {
        this.factory = factory;
        this.u32Serializer = typesFactory.getInstance(CLType.U32);
    }

    @Override
    public byte[] toBytes(Collection<?> source) {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        builder.append(this.u32Serializer.serialize(source.size()));
        source.forEach(item -> builder.append(this.factory.getByteSerializer(item).toBytes(item)));
        return builder.toByteArray();
    }

    @Override
    public Class<Collection<?>> getType() {
        return (Class)CollectionUtils.genericCast(Collection.class);
    }
}

