/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.types.CLValueByteSerializer;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.DeployNamedArg;

public class DeployNamedArgByteSerializer
implements ByteSerializer<DeployNamedArg> {
    private final CLValueByteSerializer valueSerializer;
    private final TypesSerializer u32Serializer;

    public DeployNamedArgByteSerializer(TypesFactory typesFactory) {
        this.u32Serializer = typesFactory.getInstance(CLType.U32);
        this.valueSerializer = new CLValueByteSerializer(typesFactory);
    }

    @Override
    public byte[] toBytes(DeployNamedArg source) {
        byte[] name = source.getName().getBytes();
        byte[] nameBytes = ByteUtils.concat(this.u32Serializer.serialize(name.length), name);
        byte[] valueBytes = this.valueSerializer.toBytes(source.getValue());
        return ByteUtils.concat(nameBytes, valueBytes);
    }

    @Override
    public Class<DeployNamedArg> getType() {
        return DeployNamedArg.class;
    }
}

