/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.signing;

import com.casper.sdk.exceptions.SignatureException;
import com.casper.sdk.service.signing.KeyPairBuilder;
import com.casper.sdk.service.signing.KeyPairFactory;
import com.casper.sdk.types.Algorithm;
import com.casper.sdk.types.CLPublicKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class SigningService {
    static final String PROVIDER = "BC";
    private final KeyPairFactory keyPairFactory = new KeyPairFactory();

    public KeyPair generateKeyPair(Algorithm algorithm) {
        return this.getKeyPairBuilder(algorithm).generateKeyPair(null);
    }

    public KeyPair generateKeyPair(Algorithm algorithm, byte[] seed) {
        return this.getKeyPairBuilder(algorithm).generateKeyPair(seed);
    }

    public KeyPair loadKeyPair(File publicKeyFile, File privateKeyFile) {
        try {
            return this.loadKeyPair(new FileInputStream(publicKeyFile), new FileInputStream(privateKeyFile));
        }
        catch (FileNotFoundException e) {
            throw new SignatureException(e);
        }
    }

    public KeyPair loadKeyPair(InputStream publicKeyIn, InputStream privateKeyIn) {
        return new KeyPair(this.toPublicKey(publicKeyIn), this.toPrivateKey(privateKeyIn));
    }

    public byte[] signWithPrivateKey(PrivateKey privateKey, byte[] toSign) {
        try {
            Signature sig = Signature.getInstance(privateKey.getAlgorithm(), PROVIDER);
            sig.initSign(privateKey);
            sig.update(toSign);
            return this.getKeyPairBuilder(privateKey.getAlgorithm()).convertFromDER(sig.sign());
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    public CLPublicKey toClPublicKey(PublicKey publicKey) {
        return new CLPublicKey(this.getKeyPairBuilderForPublicKey(publicKey).getPublicKeyRawBytes(publicKey));
    }

    public PublicKey fromClPublicKey(CLPublicKey publicKey) {
        return this.getKeyPairBuilder(publicKey.getAlgorithm()).createPublicKey(publicKey.getBytes());
    }

    public boolean verifySignature(PublicKey publicKey, byte[] toSign, byte[] signature) {
        try {
            Signature sig = Signature.getInstance(publicKey.getAlgorithm(), PROVIDER);
            sig.initVerify(publicKey);
            sig.update(toSign);
            return sig.verify(this.getKeyPairBuilder(publicKey.getAlgorithm()).convertToDER(signature));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void writeKey(OutputStream out, Key key) {
        try {
            JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(out));
            jcaPEMWriter.writeObject((Object)key);
            jcaPEMWriter.flush();
            jcaPEMWriter.close();
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    PrivateKey toPrivateKey(InputStream privateKeyIn) {
        return (PrivateKey)this.loadKey(privateKeyIn);
    }

    PublicKey toPublicKey(InputStream publicKeyIn) {
        return (PublicKey)this.loadKey(publicKeyIn);
    }

    private KeyPairBuilder getKeyPairBuilder(Algorithm algorithm) {
        return this.keyPairFactory.getKeyPairBuilder(algorithm);
    }

    private KeyPairBuilder getKeyPairBuilder(String algorithm) {
        return this.keyPairFactory.getKeyPairBuilder(algorithm);
    }

    private KeyPairBuilder getKeyPairBuilderForPublicKey(PublicKey publicKey) {
        return this.keyPairFactory.getKeyPairBuilderForPublicKey(publicKey);
    }

    public <T extends Key> T loadKey(InputStream keyIn) {
        try {
            PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(keyIn));
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(PROVIDER);
            if (object instanceof PrivateKeyInfo) {
                return (T)converter.getPrivateKey((PrivateKeyInfo)object);
            }
            if (object instanceof PEMKeyPair) {
                return (T)converter.getPrivateKey(((PEMKeyPair)object).getPrivateKeyInfo());
            }
            if (object instanceof SubjectPublicKeyInfo) {
                return (T)converter.getPublicKey((SubjectPublicKeyInfo)object);
            }
            throw new SignatureException("Unknown object type " + object);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

