/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;

public class VestingSchedule {
    @JsonProperty(value="initial_release_timestamp_millis")
    private BigInteger initialReleaseTimeStampMillis;
    @JsonIgnore
    private List<BigInteger> lockedAmounts;

    @JsonProperty(value="locked_amounts")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonLockedAmounts(List<String> lockedAmounts) {
        LinkedList<BigInteger> list = new LinkedList<BigInteger>();
        for (String string : lockedAmounts) {
            list.add(new BigInteger(string, 10));
        }
        this.lockedAmounts = list;
    }

    @JsonProperty(value="locked_amounts")
    @ExcludeFromJacocoGeneratedReport
    protected List<String> getJsonLockedAmounts() {
        LinkedList<String> list = new LinkedList<String>();
        for (BigInteger bi : this.lockedAmounts) {
            list.add(bi.toString(10));
        }
        return list;
    }

    public static VestingScheduleBuilder builder() {
        return new VestingScheduleBuilder();
    }

    public BigInteger getInitialReleaseTimeStampMillis() {
        return this.initialReleaseTimeStampMillis;
    }

    public List<BigInteger> getLockedAmounts() {
        return this.lockedAmounts;
    }

    @JsonProperty(value="initial_release_timestamp_millis")
    public void setInitialReleaseTimeStampMillis(BigInteger initialReleaseTimeStampMillis) {
        this.initialReleaseTimeStampMillis = initialReleaseTimeStampMillis;
    }

    @JsonIgnore
    public void setLockedAmounts(List<BigInteger> lockedAmounts) {
        this.lockedAmounts = lockedAmounts;
    }

    public VestingSchedule(BigInteger initialReleaseTimeStampMillis, List<BigInteger> lockedAmounts) {
        this.initialReleaseTimeStampMillis = initialReleaseTimeStampMillis;
        this.lockedAmounts = lockedAmounts;
    }

    public VestingSchedule() {
    }

    public static class VestingScheduleBuilder {
        private BigInteger initialReleaseTimeStampMillis;
        private List<BigInteger> lockedAmounts;

        VestingScheduleBuilder() {
        }

        @JsonProperty(value="initial_release_timestamp_millis")
        public VestingScheduleBuilder initialReleaseTimeStampMillis(BigInteger initialReleaseTimeStampMillis) {
            this.initialReleaseTimeStampMillis = initialReleaseTimeStampMillis;
            return this;
        }

        @JsonIgnore
        public VestingScheduleBuilder lockedAmounts(List<BigInteger> lockedAmounts) {
            this.lockedAmounts = lockedAmounts;
            return this;
        }

        public VestingSchedule build() {
            return new VestingSchedule(this.initialReleaseTimeStampMillis, this.lockedAmounts);
        }

        public String toString() {
            return "VestingSchedule.VestingScheduleBuilder(initialReleaseTimeStampMillis=" + this.initialReleaseTimeStampMillis + ", lockedAmounts=" + this.lockedAmounts + ")";
        }
    }
}

