/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeWithChildren;
import com.casper.sdk.model.clvalue.cltype.CLTypeData;
import com.casper.sdk.model.clvalue.cltype.CLTypeFixedList;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueDeserializationException;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class CLValueFixedList
extends AbstractCLValue<List<? extends AbstractCLValue<?, ?>>, CLTypeFixedList> {
    @JsonProperty(value="cl_type")
    private CLTypeFixedList clType = new CLTypeFixedList();

    public CLValueFixedList(List<? extends AbstractCLValue<?, ?>> value) throws ValueSerializationException {
        this.setListType(value);
        this.setValue(value);
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        if (this.getValue() == null) {
            return;
        }
        if (target.equals((Object)Target.BYTE)) {
            super.serializePrefixWithLength(ser);
        }
        this.setListType((List)this.getValue());
        for (AbstractCLValue child : (List)this.getValue()) {
            child.serialize(ser);
        }
        if (target.equals((Object)Target.BYTE)) {
            this.encodeType(ser);
        }
        this.setBytes(Hex.toHexString((byte[])ser.toByteArray()));
    }

    @Override
    public void deserializeCustom(DeserializerBuffer deser) throws Exception {
        CLTypeData childrenType = this.getClType().getListType().getClTypeData();
        LinkedList list = new LinkedList();
        boolean hasMoreItems = true;
        do {
            AbstractCLValue<?, ?> child;
            if ((child = CLTypeData.createCLValueFromCLTypeData(childrenType)).getClType() instanceof AbstractCLTypeWithChildren) {
                ((AbstractCLTypeWithChildren)child.getClType()).setChildTypes(((AbstractCLTypeWithChildren)this.clType.getListType()).getChildTypes());
            }
            try {
                child.deserializeCustom(deser);
                list.add(child);
            }
            catch (ValueDeserializationException valueDeserializationException) {
                hasMoreItems = false;
                if (!deser.getBuffer().hasRemaining()) continue;
                throw valueDeserializationException;
            }
        } while (hasMoreItems);
        this.setValue(list);
    }

    protected void setListType(List<? extends AbstractCLValue<?, ?>> value) {
        this.clType.setListType((AbstractCLType)value.get(0).getClType());
    }

    @Override
    public CLTypeFixedList getClType() {
        return this.clType;
    }

    @Override
    @JsonProperty(value="cl_type")
    public void setClType(CLTypeFixedList clType) {
        this.clType = clType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLValueFixedList)) {
            return false;
        }
        CLValueFixedList other = (CLValueFixedList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CLTypeFixedList this$clType = this.getClType();
        CLTypeFixedList other$clType = other.getClType();
        return !(this$clType == null ? other$clType != null : !((Object)this$clType).equals(other$clType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CLValueFixedList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CLTypeFixedList $clType = this.getClType();
        result = result * 59 + ($clType == null ? 43 : ((Object)$clType).hashCode());
        return result;
    }

    public CLValueFixedList() {
    }
}

