/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.AbstractCLValueWithChildren;
import com.casper.sdk.model.clvalue.CLValueI32;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeWithChildren;
import com.casper.sdk.model.clvalue.cltype.CLTypeData;
import com.casper.sdk.model.clvalue.cltype.CLTypeList;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class CLValueList
extends AbstractCLValueWithChildren<List<? extends AbstractCLValue<?, ?>>, CLTypeList> {
    @JsonProperty(value="cl_type")
    private CLTypeList clType = new CLTypeList();

    public CLValueList(List<? extends AbstractCLValue<?, ?>> value) throws ValueSerializationException {
        this.setChildTypes(value);
        this.setValue(value);
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        if (this.getValue() == null) {
            return;
        }
        if (target.equals((Object)Target.BYTE)) {
            super.serializePrefixWithLength(ser);
        }
        this.setChildTypes((List)this.getValue());
        CLValueI32 length = new CLValueI32(((List)this.getValue()).size());
        length.serialize(ser);
        for (AbstractCLValue child : (List)this.getValue()) {
            child.serialize(ser);
        }
        if (target.equals((Object)Target.BYTE)) {
            this.encodeType(ser);
        }
        this.setBytes(Hex.toHexString((byte[])ser.toByteArray()));
    }

    @Override
    public void deserializeCustom(DeserializerBuffer deser) throws Exception {
        CLTypeData childrenType = this.getClType().getListType().getClTypeData();
        CLValueI32 length = new CLValueI32();
        length.deserializeCustom(deser);
        LinkedList list = new LinkedList();
        for (int i = 0; i < (Integer)length.getValue(); ++i) {
            AbstractCLValue<?, ?> child = CLTypeData.createCLValueFromCLTypeData(childrenType);
            if (child.getClType() instanceof AbstractCLTypeWithChildren) {
                ((AbstractCLTypeWithChildren)child.getClType()).setChildTypes(((AbstractCLTypeWithChildren)this.clType.getListType()).getChildTypes());
            }
            child.deserializeCustom(deser);
            list.add(child);
        }
        this.setValue(list);
    }

    @Override
    protected void setChildTypes(List<? extends AbstractCLValue<?, ?>> value) {
        this.clType.setListType((AbstractCLType)value.get(0).getClType());
    }

    @Override
    public CLTypeList getClType() {
        return this.clType;
    }

    @Override
    @JsonProperty(value="cl_type")
    public void setClType(CLTypeList clType) {
        this.clType = clType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLValueList)) {
            return false;
        }
        CLValueList other = (CLValueList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CLTypeList this$clType = this.getClType();
        CLTypeList other$clType = other.getClType();
        return !(this$clType == null ? other$clType != null : !((Object)this$clType).equals(other$clType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CLValueList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CLTypeList $clType = this.getClType();
        result = result * 59 + ($clType == null ? 43 : ((Object)$clType).hashCode());
        return result;
    }

    public CLValueList() {
    }
}

