/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.CLValueByteArray;
import com.casper.sdk.model.clvalue.CLValueU8;
import com.casper.sdk.model.clvalue.cltype.CLTypeURef;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.uref.URef;
import com.casper.sdk.model.uref.URefAccessRight;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;

public class CLValueURef
extends AbstractCLValue<URef, CLTypeURef> {
    private CLTypeURef clType = new CLTypeURef();

    public CLValueURef(URef value) throws ValueSerializationException {
        this.setValue(value);
    }

    @JsonGetter(value="cl_type")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonClType() {
        return this.getClType().getTypeName();
    }

    @JsonSetter(value="cl_type")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonClType(CLTypeURef clType) {
        this.clType = clType;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws NoSuchTypeException, ValueSerializationException {
        if (this.getValue() == null) {
            return;
        }
        if (target.equals((Object)Target.BYTE)) {
            super.serializePrefixWithLength(ser);
        }
        URef uref = (URef)this.getValue();
        byte[] urefByte = new byte[uref.getAddress().length + 1];
        System.arraycopy(uref.getAddress(), 0, urefByte, 0, uref.getAddress().length);
        urefByte[32] = uref.getAccessRight().serializationTag;
        ser.writeByteArray(urefByte);
        if (target.equals((Object)Target.BYTE)) {
            this.encodeType(ser);
        }
        this.setBytes(Hex.toHexString((byte[])ser.toByteArray()));
    }

    @Override
    public void deserializeCustom(DeserializerBuffer deser) throws Exception {
        URef uref = new URef();
        CLValueByteArray clValueByteArray = new CLValueByteArray(new byte[32]);
        clValueByteArray.deserializeCustom(deser);
        uref.setAddress((byte[])clValueByteArray.getValue());
        CLValueU8 serializationTag = new CLValueU8((byte)0);
        serializationTag.deserializeCustom(deser);
        uref.setAccessRight(URefAccessRight.getTypeBySerializationTag((Byte)serializationTag.getValue()));
        this.setValue(uref);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public boolean equals(Object o) {
        URef otherValue;
        String otherBytes;
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLValueURef)) {
            return false;
        }
        CLValueURef other = (CLValueURef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String thisBytes = this.getBytes();
        if (!Objects.equals(thisBytes, otherBytes = other.getBytes())) {
            return false;
        }
        URef thisValue = (URef)this.getValue();
        if (!Objects.equals(thisValue, otherValue = (URef)other.getValue())) {
            return false;
        }
        CLTypeURef thisClType = this.getClType();
        CLTypeURef otherClType = other.getClType();
        return Objects.equals(thisClType, otherClType);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    protected boolean canEqual(Object other) {
        return other instanceof CLValueURef;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CLTypeURef thisClType = this.getClType();
        result = result * 59 + (thisClType == null ? 43 : ((Object)thisClType).hashCode());
        return result;
    }

    @Override
    public CLTypeURef getClType() {
        return this.clType;
    }

    @Override
    public void setClType(CLTypeURef clType) {
        this.clType = clType;
    }

    public CLValueURef() {
    }
}

