/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue.cltype;

import com.casper.sdk.exception.DynamicInstanceException;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.CLValueAny;
import com.casper.sdk.model.clvalue.CLValueBool;
import com.casper.sdk.model.clvalue.CLValueByteArray;
import com.casper.sdk.model.clvalue.CLValueFixedList;
import com.casper.sdk.model.clvalue.CLValueI32;
import com.casper.sdk.model.clvalue.CLValueI64;
import com.casper.sdk.model.clvalue.CLValueKey;
import com.casper.sdk.model.clvalue.CLValueList;
import com.casper.sdk.model.clvalue.CLValueMap;
import com.casper.sdk.model.clvalue.CLValueOption;
import com.casper.sdk.model.clvalue.CLValuePublicKey;
import com.casper.sdk.model.clvalue.CLValueResult;
import com.casper.sdk.model.clvalue.CLValueString;
import com.casper.sdk.model.clvalue.CLValueTuple1;
import com.casper.sdk.model.clvalue.CLValueTuple2;
import com.casper.sdk.model.clvalue.CLValueTuple3;
import com.casper.sdk.model.clvalue.CLValueU128;
import com.casper.sdk.model.clvalue.CLValueU256;
import com.casper.sdk.model.clvalue.CLValueU32;
import com.casper.sdk.model.clvalue.CLValueU512;
import com.casper.sdk.model.clvalue.CLValueU64;
import com.casper.sdk.model.clvalue.CLValueU8;
import com.casper.sdk.model.clvalue.CLValueURef;
import com.casper.sdk.model.clvalue.CLValueUnit;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.CLTypeAny;
import com.casper.sdk.model.clvalue.cltype.CLTypeBool;
import com.casper.sdk.model.clvalue.cltype.CLTypeByteArray;
import com.casper.sdk.model.clvalue.cltype.CLTypeFixedList;
import com.casper.sdk.model.clvalue.cltype.CLTypeI32;
import com.casper.sdk.model.clvalue.cltype.CLTypeI64;
import com.casper.sdk.model.clvalue.cltype.CLTypeKey;
import com.casper.sdk.model.clvalue.cltype.CLTypeList;
import com.casper.sdk.model.clvalue.cltype.CLTypeMap;
import com.casper.sdk.model.clvalue.cltype.CLTypeOption;
import com.casper.sdk.model.clvalue.cltype.CLTypePublicKey;
import com.casper.sdk.model.clvalue.cltype.CLTypeResult;
import com.casper.sdk.model.clvalue.cltype.CLTypeString;
import com.casper.sdk.model.clvalue.cltype.CLTypeTuple1;
import com.casper.sdk.model.clvalue.cltype.CLTypeTuple2;
import com.casper.sdk.model.clvalue.cltype.CLTypeTuple3;
import com.casper.sdk.model.clvalue.cltype.CLTypeU128;
import com.casper.sdk.model.clvalue.cltype.CLTypeU256;
import com.casper.sdk.model.clvalue.cltype.CLTypeU32;
import com.casper.sdk.model.clvalue.cltype.CLTypeU512;
import com.casper.sdk.model.clvalue.cltype.CLTypeU64;
import com.casper.sdk.model.clvalue.cltype.CLTypeU8;
import com.casper.sdk.model.clvalue.cltype.CLTypeURef;
import com.casper.sdk.model.clvalue.cltype.CLTypeUnit;
import java.lang.reflect.InvocationTargetException;

public enum CLTypeData {
    BOOL("Bool", 0, CLValueBool.class, CLTypeBool.class),
    I32("I32", 1, CLValueI32.class, CLTypeI32.class),
    I64("I64", 2, CLValueI64.class, CLTypeI64.class),
    U8("U8", 3, CLValueU8.class, CLTypeU8.class),
    U32("U32", 4, CLValueU32.class, CLTypeU32.class),
    U64("U64", 5, CLValueU64.class, CLTypeU64.class),
    U128("U128", 6, CLValueU128.class, CLTypeU128.class),
    U256("U256", 7, CLValueU256.class, CLTypeU256.class),
    U512("U512", 8, CLValueU512.class, CLTypeU512.class),
    UNIT("Unit", 9, CLValueUnit.class, CLTypeUnit.class),
    STRING("String", 10, CLValueString.class, CLTypeString.class),
    UREF("URef", 11, CLValueURef.class, CLTypeURef.class),
    KEY("Key", 12, CLValueKey.class, CLTypeKey.class),
    OPTION("Option", 13, CLValueOption.class, CLTypeOption.class),
    LIST("List", 14, CLValueList.class, CLTypeList.class),
    FIXED_LIST("FixedList", 15, CLValueFixedList.class, CLTypeFixedList.class),
    RESULT("Result", 16, CLValueResult.class, CLTypeResult.class),
    MAP("Map", 17, CLValueMap.class, CLTypeMap.class),
    TUPLE1("Tuple1", 18, CLValueTuple1.class, CLTypeTuple1.class),
    TUPLE2("Tuple2", 19, CLValueTuple2.class, CLTypeTuple2.class),
    TUPLE3("Tuple3", 20, CLValueTuple3.class, CLTypeTuple3.class),
    ANY("Any", 21, CLValueAny.class, CLTypeAny.class),
    PUBLIC_KEY("PublicKey", 22, CLValuePublicKey.class, CLTypePublicKey.class),
    BYTE_ARRAY("ByteArray", 23, CLValueByteArray.class, CLTypeByteArray.class);

    private final String clTypeName;
    private final byte serializationTag;
    private final Class<? extends AbstractCLValue<?, ?>> clazz;
    private final Class<? extends AbstractCLType> clTypeClass;

    public static CLTypeData getTypeBySerializationTag(byte serializationTag) throws NoSuchTypeException {
        for (CLTypeData clType : CLTypeData.values()) {
            if (clType.serializationTag != serializationTag) continue;
            return clType;
        }
        throw new NoSuchTypeException();
    }

    public static Class<?> getClassByName(String name) throws NoSuchTypeException {
        for (CLTypeData clType : CLTypeData.values()) {
            if (!clType.clTypeName.equals(name)) continue;
            return clType.getClazz();
        }
        throw new NoSuchTypeException();
    }

    public static Class<?> getCLTypeClassByName(String name) throws NoSuchTypeException {
        for (CLTypeData clType : CLTypeData.values()) {
            if (!clType.clTypeName.equals(name)) continue;
            return clType.getClTypeClass();
        }
        throw new NoSuchTypeException();
    }

    public static CLTypeData getTypeByName(String name) throws NoSuchTypeException {
        for (CLTypeData clType : CLTypeData.values()) {
            if (!clType.clTypeName.equals(name)) continue;
            return clType;
        }
        throw new NoSuchTypeException();
    }

    public static AbstractCLValue<?, ?> createCLValueFromCLTypeName(String clValueName) throws DynamicInstanceException, NoSuchTypeException {
        return CLTypeData.createCLValueFromCLTypeData(CLTypeData.getTypeByName(clValueName));
    }

    public static AbstractCLValue<?, ?> createCLValueFromCLTypeData(CLTypeData clTypeData) throws DynamicInstanceException {
        Class<AbstractCLValue<?, ?>> clazz = clTypeData.getClazz();
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DynamicInstanceException(String.format("Error while instantiating %s", clazz.getName()), e);
        }
    }

    public static AbstractCLType createCLTypeFromCLTypeName(String clTypeName) throws DynamicInstanceException, NoSuchTypeException {
        return CLTypeData.createCLTypeFromCLTypeData(CLTypeData.getTypeByName(clTypeName));
    }

    public static AbstractCLType createCLTypeFromCLTypeData(CLTypeData clTypeData) throws DynamicInstanceException {
        Class<? extends AbstractCLType> clazz = clTypeData.getClTypeClass();
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DynamicInstanceException(String.format("Error while instantiating %s", clazz.getName()), e);
        }
    }

    public String getClTypeName() {
        return this.clTypeName;
    }

    public byte getSerializationTag() {
        return this.serializationTag;
    }

    public Class<? extends AbstractCLValue<?, ?>> getClazz() {
        return this.clazz;
    }

    public Class<? extends AbstractCLType> getClTypeClass() {
        return this.clTypeClass;
    }

    private CLTypeData(String clTypeName, byte serializationTag, Class<? extends AbstractCLValue<?, ?>> clazz, Class<? extends AbstractCLType> clTypeClass) {
        this.clTypeName = clTypeName;
        this.serializationTag = serializationTag;
        this.clazz = clazz;
        this.clTypeClass = clTypeClass;
    }
}

