/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy.executionresult;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.deploy.ExecutionEffect;
import com.casper.sdk.model.deploy.executionresult.ExecutionResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigInteger;
import java.util.List;

@JsonTypeName(value="Failure")
public class Failure
implements ExecutionResult {
    @JsonIgnore
    private BigInteger cost;
    private ExecutionEffect effect;
    @JsonProperty(value="error_message")
    private String errorMessage;
    private List<String> transfers;

    @JsonProperty(value="cost")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonCost() {
        return this.cost.toString(10);
    }

    @JsonProperty(value="cost")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonCost(String value) {
        this.cost = new BigInteger(value, 10);
    }

    public static FailureBuilder builder() {
        return new FailureBuilder();
    }

    public BigInteger getCost() {
        return this.cost;
    }

    public ExecutionEffect getEffect() {
        return this.effect;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<String> getTransfers() {
        return this.transfers;
    }

    @JsonIgnore
    public void setCost(BigInteger cost) {
        this.cost = cost;
    }

    public void setEffect(ExecutionEffect effect) {
        this.effect = effect;
    }

    @JsonProperty(value="error_message")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setTransfers(List<String> transfers) {
        this.transfers = transfers;
    }

    public Failure(BigInteger cost, ExecutionEffect effect, String errorMessage, List<String> transfers) {
        this.cost = cost;
        this.effect = effect;
        this.errorMessage = errorMessage;
        this.transfers = transfers;
    }

    public Failure() {
    }

    public static class FailureBuilder {
        private BigInteger cost;
        private ExecutionEffect effect;
        private String errorMessage;
        private List<String> transfers;

        FailureBuilder() {
        }

        @JsonIgnore
        public FailureBuilder cost(BigInteger cost) {
            this.cost = cost;
            return this;
        }

        public FailureBuilder effect(ExecutionEffect effect) {
            this.effect = effect;
            return this;
        }

        @JsonProperty(value="error_message")
        public FailureBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public FailureBuilder transfers(List<String> transfers) {
            this.transfers = transfers;
            return this;
        }

        public Failure build() {
            return new Failure(this.cost, this.effect, this.errorMessage, this.transfers);
        }

        public String toString() {
            return "Failure.FailureBuilder(cost=" + this.cost + ", effect=" + this.effect + ", errorMessage=" + this.errorMessage + ", transfers=" + this.transfers + ")";
        }
    }
}

