/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.jackson.deserializer.PublicKeyDeserializer;
import com.casper.sdk.model.key.AbstractSerializedKeyTaggedHex;
import com.casper.sdk.model.key.AlgorithmTag;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.syntifi.crypto.key.AbstractPublicKey;
import com.syntifi.crypto.key.Ed25519PublicKey;
import com.syntifi.crypto.key.Secp256k1PublicKey;
import dev.oak3.sbs4j.util.ByteUtils;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

@JsonDeserialize(using=PublicKeyDeserializer.class)
public class PublicKey
extends AbstractSerializedKeyTaggedHex<AlgorithmTag> {
    public static PublicKey fromTaggedHexString(String hex) throws NoSuchAlgorithmException, IllegalArgumentException {
        byte[] bytes = ByteUtils.parseHexString((String)hex);
        return PublicKey.fromBytes(bytes);
    }

    public static PublicKey fromBytes(byte[] bytes) throws NoSuchAlgorithmException {
        PublicKey object = new PublicKey();
        object.setTag(AlgorithmTag.getByTag(bytes[0]));
        object.setKey(Arrays.copyOfRange(bytes, 1, bytes.length));
        return object;
    }

    public static PublicKey fromAbstractPublicKey(AbstractPublicKey key) {
        PublicKey object = new PublicKey();
        object.setTag(key instanceof Secp256k1PublicKey ? AlgorithmTag.SECP256K1 : AlgorithmTag.ED25519);
        object.setKey(key.getKey());
        return object;
    }

    @JsonCreator
    public void createPublicKey(String key) throws NoSuchAlgorithmException, IllegalArgumentException {
        PublicKey obj = PublicKey.fromTaggedHexString(key);
        this.setTag((AlgorithmTag)obj.getTag());
        this.setKey(obj.getKey());
    }

    @JsonIgnore
    public AbstractPublicKey getPubKey() throws NoSuchAlgorithmException {
        if (((AlgorithmTag)this.getTag()).equals(AlgorithmTag.ED25519)) {
            return new Ed25519PublicKey(this.getKey());
        }
        if (((AlgorithmTag)this.getTag()).equals(AlgorithmTag.SECP256K1)) {
            return new Secp256k1PublicKey(this.getKey());
        }
        throw new NoSuchAlgorithmException();
    }
}

