/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.impl.event;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.model.event.Event;
import com.casper.sdk.model.event.EventTarget;
import com.casper.sdk.model.event.EventType;
import com.casper.sdk.service.EventConsumer;
import com.casper.sdk.service.EventService;
import com.casper.sdk.service.impl.event.EventBuilder;
import com.casper.sdk.service.impl.event.EventUrlBuilder;
import com.casper.sdk.service.impl.event.StopException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.time.Duration;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

final class EventServiceImpl
implements EventService {
    private static final String APPLICATION_JSON = "application/json";
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    private final EventUrlBuilder urlBuilder = new EventUrlBuilder();
    private final URI uri;
    final OkHttpClient client;

    private EventServiceImpl(URI uri) {
        this.uri = uri;
        this.client = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(10L)).readTimeout(Duration.ofSeconds(30L)).build();
    }

    @Override
    public <EventT extends Event<?>> void consumeEvents(EventType eventType, EventTarget eventTarget, Long startFrom, Consumer<EventT> eventTConsumer) {
        try {
            Response response = this.client.newCall(new Request.Builder().url(this.urlBuilder.buildUrl(this.uri, eventType, startFrom)).header(ACCEPT, APPLICATION_JSON).header(CONTENT_TYPE, APPLICATION_JSON).get().build()).execute();
            if (!response.isSuccessful() || response.body() == null) {
                throw new CasperClientException("No response from node " + this.uri);
            }
            this.consumeEvent(eventType, eventTarget, new InputStreamReader(response.body().byteStream()), eventTConsumer);
        }
        catch (IOException e) {
            throw new CasperClientException("Error executing request against node" + this.uri, e);
        }
    }

    private <EventT, DataT extends Event<DataT>> void consumeEvent(EventType eventType, EventTarget eventTarget, Reader reader, Consumer<EventT> consumer) {
        EventBuilder eventBuilder = new EventBuilder(eventType, eventTarget, this.uri.toString());
        try {
            new BufferedReader(reader).lines().filter(line -> this.throwOnStop(consumer)).filter(eventBuilder::processLine).forEach(line -> consumer.accept(eventBuilder.buildEvent()));
        }
        catch (StopException stopException) {
            // empty catch block
        }
    }

    private <EventT> boolean throwOnStop(Consumer<EventT> consumer) {
        if (consumer instanceof EventConsumer && ((EventConsumer)consumer).isStop()) {
            throw new StopException();
        }
        return true;
    }
}

