/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.cltype.CLTypeByteArray;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import dev.oak3.sbs4j.util.ByteUtils;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;

public class CLValueByteArray
extends AbstractCLValue<byte[], CLTypeByteArray> {
    @JsonProperty(value="cl_type")
    private CLTypeByteArray clType = new CLTypeByteArray();

    public CLValueByteArray(byte[] value) throws ValueSerializationException {
        this.setValue(value);
        this.clType.setLength(value.length);
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws NoSuchTypeException, ValueSerializationException {
        if (this.getValue() == null) {
            return;
        }
        if (target.equals((Object)Target.BYTE)) {
            super.serializePrefixWithLength(ser);
        }
        ser.writeByteArray((byte[])this.getValue());
        if (target.equals((Object)Target.BYTE)) {
            this.encodeType(ser);
        }
        this.setBytes(Hex.toHexString((byte[])ser.toByteArray()));
    }

    @Override
    public void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.setValue(deser.readByteArray(this.getClType().getLength()));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public boolean equals(Object o) {
        String otherBytes;
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLValueByteArray)) {
            return false;
        }
        CLValueByteArray other = (CLValueByteArray)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String thisBytes = this.getBytes();
        if (!Objects.equals(thisBytes, otherBytes = other.getBytes())) {
            return false;
        }
        byte[] thisValue = (byte[])this.getValue();
        byte[] otherValue = (byte[])other.getValue();
        if (thisValue == null ? otherValue != null : !Arrays.equals(thisValue, otherValue)) {
            return false;
        }
        CLTypeByteArray thisClType = this.getClType();
        CLTypeByteArray otherClType = other.getClType();
        return Objects.equals(thisClType, otherClType);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    protected boolean canEqual(Object other) {
        return other instanceof CLValueByteArray;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CLTypeByteArray thisClType = this.getClType();
        result = result * 59 + (thisClType == null ? 43 : ((Object)thisClType).hashCode());
        return result;
    }

    public String toString() {
        return this.getValue() != null ? ByteUtils.encodeHexString((byte[])((byte[])this.getValue())) : null;
    }

    @Override
    public CLTypeByteArray getClType() {
        return this.clType;
    }

    @Override
    @JsonProperty(value="cl_type")
    public void setClType(CLTypeByteArray clType) {
        this.clType = clType;
    }

    public CLValueByteArray() {
    }
}

