/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.AbstractCLValueWithChildren;
import com.casper.sdk.model.clvalue.CLValueBool;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeWithChildren;
import com.casper.sdk.model.clvalue.cltype.CLTypeData;
import com.casper.sdk.model.clvalue.cltype.CLTypeList;
import com.casper.sdk.model.clvalue.cltype.CLTypeOption;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.Optional;
import org.bouncycastle.util.encoders.Hex;

public class CLValueOption
extends AbstractCLValueWithChildren<Optional<AbstractCLValue<?, ?>>, CLTypeOption> {
    @JsonProperty(value="cl_type")
    private CLTypeOption clType = new CLTypeOption();

    @Override
    @JsonSetter(value="cl_type")
    public void setClType(CLTypeOption clType) {
        this.clType = clType;
        this.childTypesSet();
    }

    public CLValueOption(Optional<AbstractCLValue<?, ?>> value) throws ValueSerializationException {
        this.setChildTypes(value);
        this.setValue(value);
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        Optional value;
        if (!((Optional)this.getValue()).isPresent()) {
            return;
        }
        if (target.equals((Object)Target.BYTE)) {
            super.serializePrefixWithLength(ser);
        }
        CLValueBool isPresent = new CLValueBool((value = (Optional)this.getValue()).isPresent() && ((AbstractCLValue)value.get()).getValue() != null);
        isPresent.serialize(ser);
        Optional child = (Optional)this.getValue();
        if (child.isPresent() && ((AbstractCLValue)child.get()).getClType() instanceof AbstractCLTypeWithChildren) {
            ((AbstractCLTypeWithChildren)((AbstractCLValue)child.get()).getClType()).setChildTypes(((AbstractCLTypeWithChildren)this.clType.getOptionType()).getChildTypes());
        }
        if (child.isPresent() && ((Boolean)isPresent.getValue()).equals(Boolean.TRUE)) {
            ((AbstractCLValue)child.get()).serialize(ser);
        }
        if (target.equals((Object)Target.BYTE)) {
            this.encodeType(ser);
            if (child.isPresent()) {
                ((AbstractCLValue)child.get()).encodeType(ser);
            }
        }
        this.setBytes(Hex.toHexString((byte[])ser.toByteArray()));
    }

    @Override
    public void deserializeCustom(DeserializerBuffer deser) throws Exception {
        CLValueBool isPresent = new CLValueBool();
        isPresent.deserializeCustom(deser);
        CLTypeData childTypeData = this.clType.getOptionType().getClTypeData();
        AbstractCLValue<?, ?> child = CLTypeData.createCLValueFromCLTypeData(childTypeData);
        if (child.getClType() instanceof CLTypeList) {
            ((CLTypeList)child.getClType()).setListType(((CLTypeList)this.clType.getOptionType()).getListType());
        } else if (child.getClType() instanceof AbstractCLTypeWithChildren) {
            ((AbstractCLTypeWithChildren)child.getClType()).setChildTypes(((AbstractCLTypeWithChildren)this.clType.getOptionType()).getChildTypes());
        }
        if (((Boolean)isPresent.getValue()).equals(Boolean.TRUE)) {
            child.deserializeCustom(deser);
        }
        this.setValue(Optional.of(child));
    }

    @Override
    protected void setChildTypes(Optional<AbstractCLValue<?, ?>> value) {
        this.clType.setOptionType(value.isPresent() ? (AbstractCLType)value.get().getClType() : null);
    }

    public String toString() {
        return this.getValue() != null && ((Optional)this.getValue()).isPresent() && ((AbstractCLValue)((Optional)this.getValue()).get()).getValue() != null ? ((AbstractCLValue)((Optional)this.getValue()).get()).toString() : "None";
    }

    @Override
    public CLTypeOption getClType() {
        return this.clType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLValueOption)) {
            return false;
        }
        CLValueOption other = (CLValueOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CLTypeOption this$clType = this.getClType();
        CLTypeOption other$clType = other.getClType();
        return !(this$clType == null ? other$clType != null : !((Object)this$clType).equals(other$clType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CLValueOption;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CLTypeOption $clType = this.getClType();
        result = result * 59 + ($clType == null ? 43 : ((Object)$clType).hashCode());
        return result;
    }

    public CLValueOption() {
    }
}

