/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.model.deploy.Deploy;
import com.casper.sdk.model.deploy.JsonExecutionResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class DeployData {
    @JsonProperty(value="api_version")
    private String apiVersion;
    @JsonProperty(value="deploy")
    private Deploy deploy;
    @JsonProperty(value="execution_results")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<JsonExecutionResult> executionResults;

    public static DeployDataBuilder builder() {
        return new DeployDataBuilder();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Deploy getDeploy() {
        return this.deploy;
    }

    public List<JsonExecutionResult> getExecutionResults() {
        return this.executionResults;
    }

    @JsonProperty(value="api_version")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="deploy")
    public void setDeploy(Deploy deploy) {
        this.deploy = deploy;
    }

    @JsonProperty(value="execution_results")
    public void setExecutionResults(List<JsonExecutionResult> executionResults) {
        this.executionResults = executionResults;
    }

    public DeployData(String apiVersion, Deploy deploy, List<JsonExecutionResult> executionResults) {
        this.apiVersion = apiVersion;
        this.deploy = deploy;
        this.executionResults = executionResults;
    }

    public DeployData() {
    }

    public static class DeployDataBuilder {
        private String apiVersion;
        private Deploy deploy;
        private List<JsonExecutionResult> executionResults;

        DeployDataBuilder() {
        }

        @JsonProperty(value="api_version")
        public DeployDataBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @JsonProperty(value="deploy")
        public DeployDataBuilder deploy(Deploy deploy) {
            this.deploy = deploy;
            return this;
        }

        @JsonProperty(value="execution_results")
        public DeployDataBuilder executionResults(List<JsonExecutionResult> executionResults) {
            this.executionResults = executionResults;
            return this;
        }

        public DeployData build() {
            return new DeployData(this.apiVersion, this.deploy, this.executionResults);
        }

        public String toString() {
            return "DeployData.DeployDataBuilder(apiVersion=" + this.apiVersion + ", deploy=" + this.deploy + ", executionResults=" + this.executionResults + ")";
        }
    }
}

