/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.impl.event;

import com.casper.sdk.model.event.DataType;
import com.casper.sdk.model.event.Event;
import com.casper.sdk.model.event.EventType;
import java.util.Optional;

abstract class AbstractEvent<T>
implements Event<T> {
    private final EventType eventType;
    private final DataType dataType;
    private final String source;
    private final Long id;
    private final T data;
    private final String version;

    @Override
    public Optional<Long> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    AbstractEvent(EventType eventType, DataType dataType, String source, Long id, T data, String version) {
        this.eventType = eventType;
        this.dataType = dataType;
        this.source = source;
        this.id = id;
        this.data = data;
        this.version = version;
    }

    public String toString() {
        return "AbstractEvent(eventType=" + (Object)((Object)this.eventType) + ", dataType=" + (Object)((Object)this.dataType) + ", source=" + this.source + ", id=" + this.id + ", data=" + this.data + ", version=" + this.version + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEvent)) {
            return false;
        }
        AbstractEvent other = (AbstractEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<Long> this$id = this.getId();
        Optional<Long> other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Long> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }
}

