/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.impl.event;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.model.event.Event;
import com.casper.sdk.model.event.EventData;
import com.casper.sdk.model.event.EventTarget;
import com.casper.sdk.model.event.EventType;
import com.casper.sdk.model.event.shutdown.Shutdown;
import com.casper.sdk.service.impl.event.AbstractEvent;
import com.casper.sdk.service.impl.event.EventRoot;
import com.casper.sdk.service.impl.event.PojoEvent;
import com.casper.sdk.service.impl.event.RawEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.NotNull;

final class EventBuilder {
    public static final String DATA = "data:";
    public static final String ID = "id:";
    public static final String API_VERSION = "ApiVersion";
    public static final String SHUTDOWN = "\"Shutdown\"";
    private Long id;
    private String data;
    private final EventType eventType;
    private final EventTarget eventTarget;
    private final String source;
    private boolean idExpected = true;
    private final ObjectMapper mapper;
    private String version;

    EventBuilder(EventType eventType, EventTarget eventTarget, String source) {
        this.eventType = eventType;
        this.eventTarget = eventTarget;
        this.source = source;
        this.mapper = new ObjectMapper();
    }

    boolean isComplete() {
        return (this.id != null || !this.idExpected) && this.data != null;
    }

    boolean processLine(String line) {
        try {
            String trimmed = line.trim();
            if (line.startsWith(DATA)) {
                this.data = trimmed;
                this.idExpected = this.isIdExpected(trimmed);
            }
            if (this.isId(trimmed)) {
                this.id = this.getId(trimmed);
            } else if (this.isApiVersion(trimmed)) {
                this.version = this.getVersion(trimmed);
            }
            return this.isComplete();
        }
        catch (Exception e) {
            throw new CasperClientException(e.getMessage(), e);
        }
    }

    private String getVersion(String line) {
        return line.replace("data:{\"ApiVersion\":\"", "").replace("\"}", "");
    }

    private boolean isIdExpected(String line) {
        return !this.isApiVersion(line);
    }

    private boolean isId(String line) {
        return line.startsWith(ID);
    }

    private Long getId(String line) {
        return Long.valueOf(line.substring(ID.length()));
    }

    private boolean isApiVersion(String line) {
        return line.contains(API_VERSION);
    }

    <T extends Event> T buildEvent() {
        AbstractEvent event;
        if (this.eventTarget == EventTarget.RAW) {
            event = new RawEvent(this.eventType, this.source, this.id, this.data, this.version);
        } else if (this.eventTarget == EventTarget.POJO) {
            event = this.buildPojoEvent();
        } else {
            throw new IllegalArgumentException("Unsupported eventTarget: " + (Object)((Object)this.eventTarget));
        }
        this.reset();
        return (T)event;
    }

    @NotNull
    private <T extends EventData> PojoEvent<T> buildPojoEvent() {
        PojoEvent event;
        try {
            String value = this.data.substring(DATA.length()).trim();
            EventRoot root = SHUTDOWN.equals(value) ? new EventRoot(new Shutdown()) : (EventRoot)this.mapper.readValue(value, EventRoot.class);
            event = new PojoEvent(this.eventType, this.source, this.id, EventRoot.getData(root), this.version);
        }
        catch (JsonProcessingException e) {
            throw new CasperClientException("Error building POJO event for: " + this.data, e);
        }
        return event;
    }

    private void reset() {
        this.data = null;
        this.id = null;
        this.idExpected = true;
    }
}

