/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.impl.event;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.model.event.EventType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

final class EventUrlBuilder {
    private static final String EVENTS = "/events/";
    public static final String START_FROM = "start_from";

    EventUrlBuilder() {
    }

    URL buildUrl(URI uri, EventType eventType, Long startFrom) {
        try {
            return new URL(uri.toString() + EVENTS + eventType.toString().toLowerCase() + this.buildParams(startFrom));
        }
        catch (MalformedURLException e) {
            throw new CasperClientException("Error building URL for " + uri, e);
        }
    }

    private String buildParams(Long startFrom) {
        if (startFrom != null) {
            return "?start_from=" + startFrom;
        }
        return "";
    }
}

