/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.helper;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.helper.CasperConstants;
import com.casper.sdk.helper.CasperDeployHelper;
import com.casper.sdk.model.clvalue.CLValuePublicKey;
import com.casper.sdk.model.clvalue.CLValueU512;
import com.casper.sdk.model.clvalue.CLValueU8;
import com.casper.sdk.model.clvalue.CLValueURef;
import com.casper.sdk.model.clvalue.cltype.CLTypePublicKey;
import com.casper.sdk.model.clvalue.cltype.CLTypeU512;
import com.casper.sdk.model.clvalue.cltype.CLTypeU8;
import com.casper.sdk.model.clvalue.cltype.CLTypeURef;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.common.Ttl;
import com.casper.sdk.model.deploy.Deploy;
import com.casper.sdk.model.deploy.NamedArg;
import com.casper.sdk.model.deploy.executabledeploy.ModuleBytes;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.syntifi.crypto.key.AbstractPrivateKey;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class CasperValidatorHelper {
    public static Deploy createValidatorAuctionBid(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger bidAmount, Byte delegationRate, String chainName) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        Ttl ttl = Ttl.builder().ttl(CasperConstants.DEFAULT_DEPLOY_TTL.value / 60L / 1000L + "m").build();
        return CasperValidatorHelper.createValidatorAuctionBid(signer, wasmBytes, bidAmount, delegationRate, BigInteger.valueOf(CasperConstants.STANDARD_PAYMENT_FOR_AUCTION_BID.value), chainName, CasperConstants.DEFAULT_GAS_PRICE.value, ttl, new Date(), new ArrayList<Digest>());
    }

    public static Deploy createValidatorAuctionBid(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger bidAmount, Byte delegationRate, BigInteger paymentAmount, String chainName, Long gasPrice, Ttl ttl, Date date, List<Digest> dependencies) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        PublicKey validatorKey = PublicKey.fromAbstractPublicKey(signer.derivePublicKey());
        LinkedList sessionArgs = new LinkedList();
        NamedArg<CLTypeU512> amountArg = new NamedArg<CLTypeU512>("amount", new CLValueU512(bidAmount));
        sessionArgs.add(amountArg);
        NamedArg<CLTypeU8> delegationRateArg = new NamedArg<CLTypeU8>("delegation_rate", new CLValueU8(delegationRate));
        sessionArgs.add(delegationRateArg);
        NamedArg<CLTypePublicKey> pkArg = new NamedArg<CLTypePublicKey>("public_key", new CLValuePublicKey(validatorKey));
        sessionArgs.add(pkArg);
        ModuleBytes session = ModuleBytes.builder().args(sessionArgs).bytes(wasmBytes).build();
        ModuleBytes payment = CasperDeployHelper.getPaymentModuleBytes(paymentAmount);
        return CasperDeployHelper.buildDeploy(signer, chainName, session, payment, gasPrice, ttl, date, dependencies);
    }

    public static Deploy createValidatorAuctionBidWithdraw(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger withdrawAmount, URef unboundPurse, String chainName) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        Ttl ttl = Ttl.builder().ttl(CasperConstants.DEFAULT_DEPLOY_TTL.value / 60L / 1000L + "m").build();
        return CasperValidatorHelper.createValidatorAuctionBidWithdraw(signer, wasmBytes, withdrawAmount, unboundPurse, BigInteger.valueOf(CasperConstants.STANDARD_PAYMENT_FOR_AUCTION_BID_WITHDRAWAL.value), chainName, CasperConstants.DEFAULT_GAS_PRICE.value, ttl, new Date(), new ArrayList<Digest>());
    }

    public static Deploy createValidatorAuctionBidWithdraw(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger withdrawAmount, URef unboundPurse, BigInteger paymentAmount, String chainName, Long gasPrice, Ttl ttl, Date date, List<Digest> dependencies) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        PublicKey validatorKey = PublicKey.fromAbstractPublicKey(signer.derivePublicKey());
        LinkedList sessionArgs = new LinkedList();
        NamedArg<CLTypeU512> amountArg = new NamedArg<CLTypeU512>("amount", new CLValueU512(withdrawAmount));
        sessionArgs.add(amountArg);
        NamedArg<CLTypePublicKey> pkArg = new NamedArg<CLTypePublicKey>("public_key", new CLValuePublicKey(validatorKey));
        sessionArgs.add(pkArg);
        NamedArg<CLTypeURef> unboundPurseArg = new NamedArg<CLTypeURef>("unbound_purse", new CLValueURef(unboundPurse));
        sessionArgs.add(unboundPurseArg);
        ModuleBytes session = ModuleBytes.builder().args(sessionArgs).bytes(wasmBytes).build();
        ModuleBytes payment = CasperDeployHelper.getPaymentModuleBytes(paymentAmount);
        return CasperDeployHelper.buildDeploy(signer, chainName, session, payment, gasPrice, ttl, date, dependencies);
    }

    public static Deploy createValidatorDelegation(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger amount, PublicKey validatorKey, PublicKey delegatorKey, String chainName) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        Ttl ttl = Ttl.builder().ttl(CasperConstants.DEFAULT_DEPLOY_TTL.value / 60L / 1000L + "m").build();
        return CasperValidatorHelper.createValidatorDelegation(signer, wasmBytes, amount, validatorKey, delegatorKey, BigInteger.valueOf(CasperConstants.STANDARD_PAYMENT_FOR_DELEGATION.value), chainName, CasperConstants.DEFAULT_GAS_PRICE.value, ttl, new Date(), new ArrayList<Digest>());
    }

    public static Deploy createValidatorDelegation(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger amount, PublicKey validatorKey, PublicKey delegatorKey, BigInteger paymentAmount, String chainName, Long gasPrice, Ttl ttl, Date date, List<Digest> dependencies) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        LinkedList sessionArgs = new LinkedList();
        NamedArg<CLTypeU512> amountArg = new NamedArg<CLTypeU512>("amount", new CLValueU512(amount));
        sessionArgs.add(amountArg);
        NamedArg<CLTypePublicKey> delegatorArg = new NamedArg<CLTypePublicKey>("delegator", new CLValuePublicKey(delegatorKey));
        sessionArgs.add(delegatorArg);
        NamedArg<CLTypePublicKey> validatorArg = new NamedArg<CLTypePublicKey>("validator", new CLValuePublicKey(validatorKey));
        sessionArgs.add(validatorArg);
        ModuleBytes session = ModuleBytes.builder().args(sessionArgs).bytes(wasmBytes).build();
        ModuleBytes payment = CasperDeployHelper.getPaymentModuleBytes(paymentAmount);
        return CasperDeployHelper.buildDeploy(signer, chainName, session, payment, gasPrice, ttl, date, dependencies);
    }

    public static Deploy createValidatorDelegationWithdraw(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger amount, PublicKey validatorKey, PublicKey delegatorKey, String chainName) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        Ttl ttl = Ttl.builder().ttl(CasperConstants.DEFAULT_DEPLOY_TTL.value / 60L / 1000L + "m").build();
        return CasperValidatorHelper.createValidatorDelegationWithdraw(signer, wasmBytes, amount, validatorKey, delegatorKey, BigInteger.valueOf(CasperConstants.STANDARD_PAYMENT_FOR_DELEGATION_WITHDRAWAL.value), chainName, CasperConstants.DEFAULT_GAS_PRICE.value, ttl, new Date(), new ArrayList<Digest>());
    }

    public static Deploy createValidatorDelegationWithdraw(AbstractPrivateKey signer, byte[] wasmBytes, BigInteger amount, PublicKey validatorKey, PublicKey delegatorKey, BigInteger paymentAmount, String chainName, Long gasPrice, Ttl ttl, Date date, List<Digest> dependencies) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        LinkedList sessionArgs = new LinkedList();
        NamedArg<CLTypeU512> amountArg = new NamedArg<CLTypeU512>("amount", new CLValueU512(amount));
        sessionArgs.add(amountArg);
        NamedArg<CLTypePublicKey> delegatorArg = new NamedArg<CLTypePublicKey>("delegator", new CLValuePublicKey(delegatorKey));
        sessionArgs.add(delegatorArg);
        NamedArg<CLTypePublicKey> validatorArg = new NamedArg<CLTypePublicKey>("validator", new CLValuePublicKey(validatorKey));
        sessionArgs.add(validatorArg);
        ModuleBytes session = ModuleBytes.builder().args(sessionArgs).bytes(wasmBytes).build();
        ModuleBytes payment = CasperDeployHelper.getPaymentModuleBytes(paymentAmount);
        return CasperDeployHelper.buildDeploy(signer, chainName, session, payment, gasPrice, ttl, date, dependencies);
    }

    private CasperValidatorHelper() {
    }
}

