/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.bid.Delegator;
import com.casper.sdk.model.bid.VestingSchedule;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Bid {
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    @JsonProperty(value="delegation_rate")
    private int delegationRate;
    @JsonIgnore
    private Map<PublicKey, Delegator> delegators;
    private boolean inactive;
    @JsonIgnore
    private BigInteger stakedAmount;
    @JsonProperty(value="validator_public_key")
    private PublicKey validatorPublicKey;
    @JsonProperty(value="vesting_schedule")
    private VestingSchedule vestingSchedule;

    @JsonSetter(value="delegators")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonDelegators(Map<String, Delegator> node) throws NoSuchAlgorithmException, IllegalArgumentException {
        for (Map.Entry<String, Delegator> entry : node.entrySet()) {
            PublicKey publicKey = PublicKey.fromTaggedHexString(entry.getKey());
            Delegator delegator = entry.getValue();
            this.delegators.put(publicKey, delegator);
        }
    }

    @JsonGetter(value="delegators")
    @ExcludeFromJacocoGeneratedReport
    protected Map<String, Delegator> getJsonDelegators() {
        LinkedHashMap<String, Delegator> out = new LinkedHashMap<String, Delegator>();
        for (Map.Entry<PublicKey, Delegator> entry : this.delegators.entrySet()) {
            out.put(entry.getKey().getAlgoTaggedHex(), entry.getValue());
        }
        return out;
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonStakedAmount() {
        return this.stakedAmount.toString(10);
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonStakedAmount(String value) {
        this.stakedAmount = new BigInteger(value, 10);
    }

    private static Map<PublicKey, Delegator> $default$delegators() {
        return new LinkedHashMap<PublicKey, Delegator>();
    }

    public static BidBuilder builder() {
        return new BidBuilder();
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public int getDelegationRate() {
        return this.delegationRate;
    }

    public Map<PublicKey, Delegator> getDelegators() {
        return this.delegators;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public BigInteger getStakedAmount() {
        return this.stakedAmount;
    }

    public PublicKey getValidatorPublicKey() {
        return this.validatorPublicKey;
    }

    public VestingSchedule getVestingSchedule() {
        return this.vestingSchedule;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    @JsonProperty(value="delegation_rate")
    public void setDelegationRate(int delegationRate) {
        this.delegationRate = delegationRate;
    }

    @JsonIgnore
    public void setDelegators(Map<PublicKey, Delegator> delegators) {
        this.delegators = delegators;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    @JsonIgnore
    public void setStakedAmount(BigInteger stakedAmount) {
        this.stakedAmount = stakedAmount;
    }

    @JsonProperty(value="validator_public_key")
    public void setValidatorPublicKey(PublicKey validatorPublicKey) {
        this.validatorPublicKey = validatorPublicKey;
    }

    @JsonProperty(value="vesting_schedule")
    public void setVestingSchedule(VestingSchedule vestingSchedule) {
        this.vestingSchedule = vestingSchedule;
    }

    public Bid(URef bondingPurse, int delegationRate, Map<PublicKey, Delegator> delegators, boolean inactive, BigInteger stakedAmount, PublicKey validatorPublicKey, VestingSchedule vestingSchedule) {
        this.bondingPurse = bondingPurse;
        this.delegationRate = delegationRate;
        this.delegators = delegators;
        this.inactive = inactive;
        this.stakedAmount = stakedAmount;
        this.validatorPublicKey = validatorPublicKey;
        this.vestingSchedule = vestingSchedule;
    }

    public Bid() {
        this.delegators = Bid.$default$delegators();
    }

    public static class BidBuilder {
        private URef bondingPurse;
        private int delegationRate;
        private boolean delegators$set;
        private Map<PublicKey, Delegator> delegators$value;
        private boolean inactive;
        private BigInteger stakedAmount;
        private PublicKey validatorPublicKey;
        private VestingSchedule vestingSchedule;

        BidBuilder() {
        }

        @JsonProperty(value="bonding_purse")
        public BidBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        @JsonProperty(value="delegation_rate")
        public BidBuilder delegationRate(int delegationRate) {
            this.delegationRate = delegationRate;
            return this;
        }

        @JsonIgnore
        public BidBuilder delegators(Map<PublicKey, Delegator> delegators) {
            this.delegators$value = delegators;
            this.delegators$set = true;
            return this;
        }

        public BidBuilder inactive(boolean inactive) {
            this.inactive = inactive;
            return this;
        }

        @JsonIgnore
        public BidBuilder stakedAmount(BigInteger stakedAmount) {
            this.stakedAmount = stakedAmount;
            return this;
        }

        @JsonProperty(value="validator_public_key")
        public BidBuilder validatorPublicKey(PublicKey validatorPublicKey) {
            this.validatorPublicKey = validatorPublicKey;
            return this;
        }

        @JsonProperty(value="vesting_schedule")
        public BidBuilder vestingSchedule(VestingSchedule vestingSchedule) {
            this.vestingSchedule = vestingSchedule;
            return this;
        }

        public Bid build() {
            Map delegators$value = this.delegators$value;
            if (!this.delegators$set) {
                delegators$value = Bid.$default$delegators();
            }
            return new Bid(this.bondingPurse, this.delegationRate, delegators$value, this.inactive, this.stakedAmount, this.validatorPublicKey, this.vestingSchedule);
        }

        public String toString() {
            return "Bid.BidBuilder(bondingPurse=" + this.bondingPurse + ", delegationRate=" + this.delegationRate + ", delegators$value=" + this.delegators$value + ", inactive=" + this.inactive + ", stakedAmount=" + this.stakedAmount + ", validatorPublicKey=" + this.validatorPublicKey + ", vestingSchedule=" + this.vestingSchedule + ")";
        }
    }
}

