/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.era;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.key.PublicKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

public class ValidatorWeight {
    private PublicKey validator;
    @JsonIgnore
    private BigInteger weight;

    @JsonProperty(value="weight")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonWeight() {
        return this.weight.toString(10);
    }

    @JsonProperty(value="weight")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonWeight(String value) {
        this.weight = new BigInteger(value, 10);
    }

    public static ValidatorWeightBuilder builder() {
        return new ValidatorWeightBuilder();
    }

    public PublicKey getValidator() {
        return this.validator;
    }

    public BigInteger getWeight() {
        return this.weight;
    }

    public void setValidator(PublicKey validator) {
        this.validator = validator;
    }

    @JsonIgnore
    public void setWeight(BigInteger weight) {
        this.weight = weight;
    }

    public ValidatorWeight(PublicKey validator, BigInteger weight) {
        this.validator = validator;
        this.weight = weight;
    }

    public ValidatorWeight() {
    }

    public static class ValidatorWeightBuilder {
        private PublicKey validator;
        private BigInteger weight;

        ValidatorWeightBuilder() {
        }

        public ValidatorWeightBuilder validator(PublicKey validator) {
            this.validator = validator;
            return this;
        }

        @JsonIgnore
        public ValidatorWeightBuilder weight(BigInteger weight) {
            this.weight = weight;
            return this;
        }

        public ValidatorWeight build() {
            return new ValidatorWeight(this.validator, this.weight);
        }

        public String toString() {
            return "ValidatorWeight.ValidatorWeightBuilder(validator=" + this.validator + ", weight=" + this.weight + ")";
        }
    }
}

