/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.AbstractCLValueWithChildren;
import com.casper.sdk.model.clvalue.CLValueI32;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeWithChildren;
import com.casper.sdk.model.clvalue.cltype.CLTypeData;
import com.casper.sdk.model.clvalue.cltype.CLTypeMap;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;

public class CLValueMap
extends AbstractCLValueWithChildren<Map<? extends AbstractCLValue<?, ?>, ? extends AbstractCLValue<?, ?>>, CLTypeMap> {
    @JsonProperty(value="cl_type")
    private CLTypeMap clType = new CLTypeMap();

    @Override
    @JsonSetter(value="cl_type")
    public void setClType(CLTypeMap clType) {
        this.clType = clType;
        this.childTypesSet();
    }

    public CLValueMap(Map<? extends AbstractCLValue<?, ?>, ? extends AbstractCLValue<?, ?>> value) throws ValueSerializationException {
        this.setChildTypes(value);
        this.setValue(value);
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        if (this.getValue() == null) {
            return;
        }
        if (target.equals((Object)Target.BYTE)) {
            super.serializePrefixWithLength(ser);
        }
        this.setChildTypes((Map)this.getValue());
        CLValueI32 mapLength = new CLValueI32(((Map)this.getValue()).size());
        mapLength.serialize(ser);
        for (Map.Entry entry : ((Map)this.getValue()).entrySet()) {
            ((AbstractCLValue)entry.getKey()).serialize(ser);
            ((AbstractCLValue)entry.getValue()).serialize(ser);
        }
        if (target.equals((Object)Target.BYTE)) {
            this.encodeType(ser);
        }
        this.setBytes(Hex.toHexString((byte[])ser.toByteArray()));
    }

    @Override
    public void deserializeCustom(DeserializerBuffer deser) throws Exception {
        CLTypeData keyType = this.clType.getKeyValueTypes().getKeyType().getClTypeData();
        CLTypeData valType = this.clType.getKeyValueTypes().getValueType().getClTypeData();
        LinkedHashMap map = new LinkedHashMap();
        CLValueI32 mapLength = new CLValueI32(0);
        mapLength.deserializeCustom(deser);
        for (int i = 0; i < (Integer)mapLength.getValue(); ++i) {
            AbstractCLValue<?, ?> key = CLTypeData.createCLValueFromCLTypeData(keyType);
            if (key.getClType() instanceof AbstractCLTypeWithChildren) {
                ((AbstractCLTypeWithChildren)key.getClType()).setChildTypes(((AbstractCLTypeWithChildren)this.clType.getKeyValueTypes().getKeyType()).getChildTypes());
            }
            key.deserializeCustom(deser);
            AbstractCLValue<?, ?> val = CLTypeData.createCLValueFromCLTypeData(valType);
            if (val.getClType() instanceof CLTypeMap) {
                ((CLTypeMap)val.getClType()).setKeyValueTypes(((CLTypeMap)this.clType.getKeyValueTypes().getValueType()).getKeyValueTypes());
            } else if (val.getClType() instanceof AbstractCLTypeWithChildren) {
                ((AbstractCLTypeWithChildren)val.getClType()).setChildTypes(((AbstractCLTypeWithChildren)this.clType.getKeyValueTypes().getValueType()).getChildTypes());
            }
            val.deserializeCustom(deser);
            map.put(key, val);
        }
        this.setValue(map);
    }

    @Override
    @JsonIgnore
    protected void setChildTypes(Map<? extends AbstractCLValue<?, ?>, ? extends AbstractCLValue<?, ?>> value) {
        Map.Entry<AbstractCLValue<?, ?>, AbstractCLValue<?, ?>> entry = value.entrySet().iterator().next();
        this.clType.setKeyValueTypes(new CLTypeMap.CLTypeMapEntryType((AbstractCLType)entry.getKey().getClType(), (AbstractCLType)entry.getValue().getClType()));
    }

    @Override
    public boolean equals(Object o) {
        String other$bytes;
        CLTypeMap other$clType;
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLValueMap)) {
            return false;
        }
        CLValueMap other = (CLValueMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CLTypeMap this$clType = this.getClType();
        if (!Objects.equals(this$clType, other$clType = other.getClType())) {
            return false;
        }
        String this$bytes = this.getBytes();
        if (!Objects.equals(this$bytes, other$bytes = other.getBytes())) {
            return false;
        }
        Map this$value = (Map)this.getValue();
        Map other$value = (Map)other.getValue();
        for (Map.Entry this$entry : this$value.entrySet()) {
            AbstractCLValue this$entryKey = (AbstractCLValue)this$entry.getKey();
            AbstractCLValue this$entryValue = (AbstractCLValue)this$entry.getValue();
            boolean found = false;
            for (Map.Entry other$entry : other$value.entrySet()) {
                AbstractCLValue other$entryKey = (AbstractCLValue)other$entry.getKey();
                AbstractCLValue other$entryValue = (AbstractCLValue)other$entry.getValue();
                if (!this$entryKey.equals(other$entryKey) || !this$entryValue.equals(other$entryValue)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CLValueMap;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CLTypeMap $clType = this.getClType();
        result = result * 59 + ($clType == null ? 43 : ((Object)$clType).hashCode());
        return result;
    }

    public String toString() {
        return this.getValue() != null ? ((Map)this.getValue()).keySet().stream().map(key -> key.getValue().toString() + "=" + key.getValue().toString()).collect(Collectors.joining(", ")) : null;
    }

    @Override
    public CLTypeMap getClType() {
        return this.clType;
    }

    public CLValueMap() {
    }
}

