/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy.executabledeploy;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.deploy.NamedArg;
import com.casper.sdk.model.deploy.executabledeploy.ExecutableDeployItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import dev.oak3.sbs4j.util.ByteUtils;
import java.util.Arrays;
import java.util.List;

@JsonTypeName(value="ModuleBytes")
public class ModuleBytes
implements ExecutableDeployItem {
    @JsonIgnore
    private byte[] bytes;
    private List<NamedArg<?>> args;

    @JsonProperty(value="module_bytes")
    public String getJsonBytes() {
        return ByteUtils.encodeHexString((byte[])this.bytes);
    }

    @JsonProperty(value="module_bytes")
    public void setJsonBytes(String byteContent) {
        this.bytes = ByteUtils.parseHexString((String)byteContent);
    }

    @Override
    public byte getOrder() {
        return 0;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeU8(this.getOrder());
        ser.writeI32(this.getBytes().length);
        ser.writeByteArray(this.getBytes());
        ser.writeI32(this.args.size());
        for (NamedArg<?> namedArg : this.args) {
            namedArg.serialize(ser, target);
        }
    }

    public static ModuleBytesBuilder builder() {
        return new ModuleBytesBuilder();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public List<NamedArg<?>> getArgs() {
        return this.args;
    }

    @JsonIgnore
    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setArgs(List<NamedArg<?>> args) {
        this.args = args;
    }

    public ModuleBytes(byte[] bytes, List<NamedArg<?>> args) {
        this.bytes = bytes;
        this.args = args;
    }

    public ModuleBytes() {
    }

    public static class ModuleBytesBuilder {
        private byte[] bytes;
        private List<NamedArg<?>> args;

        ModuleBytesBuilder() {
        }

        @JsonIgnore
        public ModuleBytesBuilder bytes(byte[] bytes) {
            this.bytes = bytes;
            return this;
        }

        public ModuleBytesBuilder args(List<NamedArg<?>> args) {
            this.args = args;
            return this;
        }

        public ModuleBytes build() {
            return new ModuleBytes(this.bytes, this.args);
        }

        public String toString() {
            return "ModuleBytes.ModuleBytesBuilder(bytes=" + Arrays.toString(this.bytes) + ", args=" + this.args + ")";
        }
    }
}

