/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service;

import com.casper.sdk.service.EventService;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventServiceFactory {
    private static final String IMPLEMENTATION_CLASS = "com.casper.sdk.service.impl.event.EventServiceImpl";
    private static final Map<Method, List<String>> methodParamMap = new HashMap<Method, List<String>>();
    private static final Logger logger = LoggerFactory.getLogger(EventServiceFactory.class);

    EventServiceFactory() {
    }

    static EventService create(URI uri) {
        return EventServiceFactory.proxy(EventServiceFactory.createEventService(uri));
    }

    private static EventService proxy(EventService eventService) {
        return (EventService)Proxy.newProxyInstance(EventServiceFactory.class.getClassLoader(), new Class[]{EventService.class}, (proxy, method, args) -> {
            if (logger.isDebugEnabled() && EventServiceFactory.isServiceMethod(method)) {
                logger.debug("{}({})", (Object)method.getName(), (Object)EventServiceFactory.argsToString(method, args));
            }
            return method.invoke((Object)eventService, args);
        });
    }

    private static boolean isServiceMethod(Method method) {
        return Arrays.asList(EventService.class.getDeclaredMethods()).contains(method);
    }

    private static EventService createEventService(Object param) {
        try {
            Constructor<?> constructor = Class.forName(IMPLEMENTATION_CLASS).getDeclaredConstructor(param.getClass());
            constructor.setAccessible(true);
            return (EventService)constructor.newInstance(param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String argsToString(Method method, Object[] args) {
        Iterator<String> parameterNames = EventServiceFactory.getParameterNames(method).iterator();
        StringBuilder builder = new StringBuilder();
        if (args != null) {
            for (Object arg : args) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(parameterNames.next());
                builder.append('=');
                builder.append(arg);
            }
        }
        return builder.toString();
    }

    private static List<String> getParameterNames(Method method) {
        return methodParamMap.computeIfAbsent(method, method1 -> {
            Parameter[] parameters = method1.getParameters();
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (Parameter parameter : parameters) {
                parameterNames.add(parameter.getName());
            }
            return parameterNames;
        });
    }
}

