/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.exception;

import com.casper.sdk.exception.CasperClientErrorData;
import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.service.CasperObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.ExceptionResolver;

public class CasperClientExceptionResolver
implements ExceptionResolver {
    private static final ObjectMapper objectMapper = new CasperObjectMapper();

    public Throwable resolveException(ObjectNode response) {
        try {
            JsonNode errorNode = response.get("error");
            CasperClientErrorData error = (CasperClientErrorData)objectMapper.treeToValue((TreeNode)errorNode, CasperClientErrorData.class);
            return new CasperClientException(error);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            return new CasperClientException(String.format("Could not extract error, response was: %s", response), e);
        }
    }
}

