/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.bid.VestingSchedule;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

public class Delegator {
    @JsonProperty(value="validator_public_key")
    private PublicKey validatorPublicKey;
    @JsonProperty(value="vesting_schedule")
    private VestingSchedule vestingSchedule;
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    @JsonProperty(value="delegator_public_key")
    private PublicKey delegatorPublicKey;
    @JsonIgnore
    private BigInteger stakedAmount;

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonStakedAmount() {
        return this.stakedAmount.toString(10);
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonStakedAmount(String value) {
        this.stakedAmount = new BigInteger(value, 10);
    }

    public static DelegatorBuilder builder() {
        return new DelegatorBuilder();
    }

    public PublicKey getValidatorPublicKey() {
        return this.validatorPublicKey;
    }

    public VestingSchedule getVestingSchedule() {
        return this.vestingSchedule;
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public PublicKey getDelegatorPublicKey() {
        return this.delegatorPublicKey;
    }

    public BigInteger getStakedAmount() {
        return this.stakedAmount;
    }

    @JsonProperty(value="validator_public_key")
    public void setValidatorPublicKey(PublicKey validatorPublicKey) {
        this.validatorPublicKey = validatorPublicKey;
    }

    @JsonProperty(value="vesting_schedule")
    public void setVestingSchedule(VestingSchedule vestingSchedule) {
        this.vestingSchedule = vestingSchedule;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    @JsonProperty(value="delegator_public_key")
    public void setDelegatorPublicKey(PublicKey delegatorPublicKey) {
        this.delegatorPublicKey = delegatorPublicKey;
    }

    @JsonIgnore
    public void setStakedAmount(BigInteger stakedAmount) {
        this.stakedAmount = stakedAmount;
    }

    public Delegator(PublicKey validatorPublicKey, VestingSchedule vestingSchedule, URef bondingPurse, PublicKey delegatorPublicKey, BigInteger stakedAmount) {
        this.validatorPublicKey = validatorPublicKey;
        this.vestingSchedule = vestingSchedule;
        this.bondingPurse = bondingPurse;
        this.delegatorPublicKey = delegatorPublicKey;
        this.stakedAmount = stakedAmount;
    }

    public Delegator() {
    }

    public static class DelegatorBuilder {
        private PublicKey validatorPublicKey;
        private VestingSchedule vestingSchedule;
        private URef bondingPurse;
        private PublicKey delegatorPublicKey;
        private BigInteger stakedAmount;

        DelegatorBuilder() {
        }

        @JsonProperty(value="validator_public_key")
        public DelegatorBuilder validatorPublicKey(PublicKey validatorPublicKey) {
            this.validatorPublicKey = validatorPublicKey;
            return this;
        }

        @JsonProperty(value="vesting_schedule")
        public DelegatorBuilder vestingSchedule(VestingSchedule vestingSchedule) {
            this.vestingSchedule = vestingSchedule;
            return this;
        }

        @JsonProperty(value="bonding_purse")
        public DelegatorBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        @JsonProperty(value="delegator_public_key")
        public DelegatorBuilder delegatorPublicKey(PublicKey delegatorPublicKey) {
            this.delegatorPublicKey = delegatorPublicKey;
            return this;
        }

        @JsonIgnore
        public DelegatorBuilder stakedAmount(BigInteger stakedAmount) {
            this.stakedAmount = stakedAmount;
            return this;
        }

        public Delegator build() {
            return new Delegator(this.validatorPublicKey, this.vestingSchedule, this.bondingPurse, this.delegatorPublicKey, this.stakedAmount);
        }

        public String toString() {
            return "Delegator.DelegatorBuilder(validatorPublicKey=" + this.validatorPublicKey + ", vestingSchedule=" + this.vestingSchedule + ", bondingPurse=" + this.bondingPurse + ", delegatorPublicKey=" + this.delegatorPublicKey + ", stakedAmount=" + this.stakedAmount + ")";
        }
    }
}

