/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue.cltype;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeBasic;
import com.casper.sdk.model.clvalue.cltype.CLTypeData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCLTypeWithChildren
extends AbstractCLType {
    @JsonIgnore
    private List<AbstractCLType> childTypes = new ArrayList<AbstractCLType>();
    private List<Object> childTypeObjects;

    protected void setChildTypeObjects(List<Object> childTypeObjects) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchTypeException {
        this.childTypeObjects = childTypeObjects;
        this.loadCLTypes(childTypeObjects);
    }

    protected List<Object> getChildTypeObjects() {
        if (this.childTypeObjects == null) {
            this.childTypeObjects = new ArrayList<Object>();
        }
        this.childTypeObjects.clear();
        for (AbstractCLType childType : this.getChildTypes()) {
            if (childType instanceof AbstractCLTypeBasic) {
                this.childTypeObjects.add(childType.getTypeName());
                continue;
            }
            this.childTypeObjects.add(childType);
        }
        return this.childTypeObjects;
    }

    @JsonIgnore
    public CLTypeData getChildClTypeData(int index) throws NoSuchTypeException {
        return CLTypeData.getTypeByName(this.getChildTypes().get(index).getTypeName());
    }

    @Override
    public boolean isDeserializable() {
        return this.getChildTypes().stream().allMatch(AbstractCLType::isDeserializable);
    }

    protected void loadCLTypes(List<Object> childTypeObjects) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchTypeException {
        this.childTypes.clear();
        if (childTypeObjects != null) {
            for (Object childTypeObject : childTypeObjects) {
                this.addChildType(childTypeObject, this.childTypes);
            }
        }
    }

    private void addChildType(Object childTypeObject, List<AbstractCLType> parent) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchTypeException {
        block3: {
            block4: {
                block2: {
                    if (!(childTypeObject instanceof String)) break block2;
                    parent.add(CLTypeData.getTypeByName(childTypeObject.toString()).getClTypeClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                    break block3;
                }
                if (!(childTypeObject instanceof List)) break block4;
                for (Object child : (List)childTypeObject) {
                    this.addChildType(child, parent);
                }
                break block3;
            }
            if (!(childTypeObject instanceof Map)) break block3;
            LinkedHashMap subChildTypes = (LinkedHashMap)childTypeObject;
            for (Map.Entry entry : subChildTypes.entrySet()) {
                AbstractCLType nextParent = CLTypeData.getTypeByName(entry.getKey().toString()).getClTypeClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                parent.add(nextParent);
                this.addChildType(entry.getValue(), ((AbstractCLTypeWithChildren)nextParent).getChildTypes());
            }
        }
    }

    @JsonIgnore
    public void setChildTypes(List<AbstractCLType> childTypes) {
        this.childTypes = childTypes;
    }

    public List<AbstractCLType> getChildTypes() {
        return this.childTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCLTypeWithChildren)) {
            return false;
        }
        AbstractCLTypeWithChildren other = (AbstractCLTypeWithChildren)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AbstractCLType> this$childTypes = this.getChildTypes();
        List<AbstractCLType> other$childTypes = other.getChildTypes();
        return !(this$childTypes == null ? other$childTypes != null : !((Object)this$childTypes).equals(other$childTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractCLTypeWithChildren;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AbstractCLType> $childTypes = this.getChildTypes();
        result = result * 59 + ($childTypes == null ? 43 : ((Object)$childTypes).hashCode());
        return result;
    }
}

