/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.block;

import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.era.JsonEraEnd;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;

public class JsonBlockHeader {
    private long height;
    @JsonProperty(value="state_root_hash")
    private Digest stateRootHash;
    @JsonProperty(value="random_bit")
    private boolean randomBit;
    @JsonProperty(value="era_end")
    private JsonEraEnd eraEnd;
    @JsonProperty(value="body_hash")
    private Digest bodyHash;
    @JsonProperty(value="parent_hash")
    private Digest parentHash;
    @JsonProperty(value="accumulated_seed")
    private Digest accumulatedSeed;
    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date timeStamp;
    @JsonProperty(value="era_id")
    private long eraId;
    @JsonProperty(value="protocol_version")
    private String protocolVersion;

    public static JsonBlockHeaderBuilder builder() {
        return new JsonBlockHeaderBuilder();
    }

    public long getHeight() {
        return this.height;
    }

    public Digest getStateRootHash() {
        return this.stateRootHash;
    }

    public boolean isRandomBit() {
        return this.randomBit;
    }

    public JsonEraEnd getEraEnd() {
        return this.eraEnd;
    }

    public Digest getBodyHash() {
        return this.bodyHash;
    }

    public Digest getParentHash() {
        return this.parentHash;
    }

    public Digest getAccumulatedSeed() {
        return this.accumulatedSeed;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public long getEraId() {
        return this.eraId;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    @JsonProperty(value="state_root_hash")
    public void setStateRootHash(Digest stateRootHash) {
        this.stateRootHash = stateRootHash;
    }

    @JsonProperty(value="random_bit")
    public void setRandomBit(boolean randomBit) {
        this.randomBit = randomBit;
    }

    @JsonProperty(value="era_end")
    public void setEraEnd(JsonEraEnd eraEnd) {
        this.eraEnd = eraEnd;
    }

    @JsonProperty(value="body_hash")
    public void setBodyHash(Digest bodyHash) {
        this.bodyHash = bodyHash;
    }

    @JsonProperty(value="parent_hash")
    public void setParentHash(Digest parentHash) {
        this.parentHash = parentHash;
    }

    @JsonProperty(value="accumulated_seed")
    public void setAccumulatedSeed(Digest accumulatedSeed) {
        this.accumulatedSeed = accumulatedSeed;
    }

    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    @JsonProperty(value="era_id")
    public void setEraId(long eraId) {
        this.eraId = eraId;
    }

    @JsonProperty(value="protocol_version")
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public JsonBlockHeader(long height, Digest stateRootHash, boolean randomBit, JsonEraEnd eraEnd, Digest bodyHash, Digest parentHash, Digest accumulatedSeed, Date timeStamp, long eraId, String protocolVersion) {
        this.height = height;
        this.stateRootHash = stateRootHash;
        this.randomBit = randomBit;
        this.eraEnd = eraEnd;
        this.bodyHash = bodyHash;
        this.parentHash = parentHash;
        this.accumulatedSeed = accumulatedSeed;
        this.timeStamp = timeStamp;
        this.eraId = eraId;
        this.protocolVersion = protocolVersion;
    }

    public JsonBlockHeader() {
    }

    public static class JsonBlockHeaderBuilder {
        private long height;
        private Digest stateRootHash;
        private boolean randomBit;
        private JsonEraEnd eraEnd;
        private Digest bodyHash;
        private Digest parentHash;
        private Digest accumulatedSeed;
        private Date timeStamp;
        private long eraId;
        private String protocolVersion;

        JsonBlockHeaderBuilder() {
        }

        public JsonBlockHeaderBuilder height(long height) {
            this.height = height;
            return this;
        }

        @JsonProperty(value="state_root_hash")
        public JsonBlockHeaderBuilder stateRootHash(Digest stateRootHash) {
            this.stateRootHash = stateRootHash;
            return this;
        }

        @JsonProperty(value="random_bit")
        public JsonBlockHeaderBuilder randomBit(boolean randomBit) {
            this.randomBit = randomBit;
            return this;
        }

        @JsonProperty(value="era_end")
        public JsonBlockHeaderBuilder eraEnd(JsonEraEnd eraEnd) {
            this.eraEnd = eraEnd;
            return this;
        }

        @JsonProperty(value="body_hash")
        public JsonBlockHeaderBuilder bodyHash(Digest bodyHash) {
            this.bodyHash = bodyHash;
            return this;
        }

        @JsonProperty(value="parent_hash")
        public JsonBlockHeaderBuilder parentHash(Digest parentHash) {
            this.parentHash = parentHash;
            return this;
        }

        @JsonProperty(value="accumulated_seed")
        public JsonBlockHeaderBuilder accumulatedSeed(Digest accumulatedSeed) {
            this.accumulatedSeed = accumulatedSeed;
            return this;
        }

        @JsonProperty(value="timestamp")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
        public JsonBlockHeaderBuilder timeStamp(Date timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        @JsonProperty(value="era_id")
        public JsonBlockHeaderBuilder eraId(long eraId) {
            this.eraId = eraId;
            return this;
        }

        @JsonProperty(value="protocol_version")
        public JsonBlockHeaderBuilder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public JsonBlockHeader build() {
            return new JsonBlockHeader(this.height, this.stateRootHash, this.randomBit, this.eraEnd, this.bodyHash, this.parentHash, this.accumulatedSeed, this.timeStamp, this.eraId, this.protocolVersion);
        }

        public String toString() {
            return "JsonBlockHeader.JsonBlockHeaderBuilder(height=" + this.height + ", stateRootHash=" + this.stateRootHash + ", randomBit=" + this.randomBit + ", eraEnd=" + this.eraEnd + ", bodyHash=" + this.bodyHash + ", parentHash=" + this.parentHash + ", accumulatedSeed=" + this.accumulatedSeed + ", timeStamp=" + this.timeStamp + ", eraId=" + this.eraId + ", protocolVersion=" + this.protocolVersion + ")";
        }
    }
}

