/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.jackson.resolver.CLValueResolver;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.CLTypeData;
import com.casper.sdk.model.clvalue.serde.CasperDeserializableObject;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueDeserializationException;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import dev.oak3.sbs4j.util.ByteUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@JsonTypeResolver(value=CLValueResolver.class)
public abstract class AbstractCLValue<T, P extends AbstractCLType>
implements CasperSerializableObject,
CasperDeserializableObject {
    private String bytes = "";
    @JsonProperty(value="parsed")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Object parsed;
    @JsonIgnore
    private T value;

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) throws ValueSerializationException {
        this.value = value;
        this.serialize(new SerializerBuffer());
    }

    public static AbstractCLValue<?, ?> createInstanceFromBytes(DeserializerBuffer deser) throws ValueDeserializationException {
        int length = deser.readI32();
        byte[] bytes = deser.readByteArray(length);
        byte clType = deser.readU8();
        try {
            AbstractCLValue<?, ?> clValue = CLTypeData.getTypeBySerializationTag(clType).getClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            clValue.deserializeCustom(new DeserializerBuffer(Hex.encode((byte[])bytes)));
            return clValue;
        }
        catch (Exception e) {
            throw new ValueDeserializationException("Error while instantiating CLValue", (Throwable)e);
        }
    }

    @JsonGetter(value="bytes")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonBytes() {
        SerializerBuffer ser = new SerializerBuffer();
        this.serialize(ser, Target.JSON);
        this.bytes = ByteUtils.encodeHexString((byte[])ser.toByteArray());
        return this.bytes;
    }

    @JsonSetter(value="bytes")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonBytes(String bytes) {
        this.bytes = bytes;
        DeserializerBuffer deser = new DeserializerBuffer(this.bytes);
        this.deserialize(deser);
    }

    @JsonIgnore
    public abstract P getClType();

    public abstract void setClType(P var1);

    protected void serializePrefixWithLength(SerializerBuffer ser) throws ValueSerializationException {
        SerializerBuffer localSer = new SerializerBuffer();
        this.serialize(localSer);
        int size = localSer.toByteArray().length;
        ser.writeI32(size);
    }

    @Override
    public AbstractCLValue<?, ?> deserialize(DeserializerBuffer deser, Target target) throws ValueDeserializationException {
        if (target.equals((Object)Target.BYTE)) {
            return AbstractCLValue.createInstanceFromBytes(deser);
        }
        this.deserialize(deser);
        return this;
    }

    @Override
    public abstract void serialize(SerializerBuffer var1, Target var2) throws ValueSerializationException, NoSuchTypeException;

    public abstract void deserializeCustom(DeserializerBuffer var1) throws Exception;

    @Override
    public void deserialize(DeserializerBuffer deserializerBuffer) throws ValueDeserializationException {
        try {
            this.deserializeCustom(deserializerBuffer);
        }
        catch (Exception e) {
            throw new ValueDeserializationException("Error deserializing value", (Throwable)e);
        }
    }

    protected void encodeType(SerializerBuffer ser) throws NoSuchTypeException {
        byte typeTag = ((AbstractCLType)this.getClType()).getClTypeData().getSerializationTag();
        ser.writeU8(typeTag);
    }

    public String getBytes() {
        return this.bytes;
    }

    public Object getParsed() {
        return this.parsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCLValue)) {
            return false;
        }
        AbstractCLValue other = (AbstractCLValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bytes = this.getBytes();
        String other$bytes = other.getBytes();
        if (this$bytes == null ? other$bytes != null : !this$bytes.equals(other$bytes)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractCLValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : $bytes.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    protected void setBytes(String bytes) {
        this.bytes = bytes;
    }

    @JsonProperty(value="parsed")
    public void setParsed(Object parsed) {
        this.parsed = parsed;
    }
}

