/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.bid.JsonDelegator;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.List;

public class JsonBid {
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    @JsonProperty(value="delegation_rate")
    private int delegationRate;
    private List<JsonDelegator> delegators;
    private boolean inactive;
    @JsonIgnore
    private BigInteger stakedAmount;

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonStakedAmount() {
        return this.stakedAmount.toString(10);
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonStakedAmount(String value) {
        this.stakedAmount = new BigInteger(value, 10);
    }

    public static JsonBidBuilder builder() {
        return new JsonBidBuilder();
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public int getDelegationRate() {
        return this.delegationRate;
    }

    public List<JsonDelegator> getDelegators() {
        return this.delegators;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public BigInteger getStakedAmount() {
        return this.stakedAmount;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    @JsonProperty(value="delegation_rate")
    public void setDelegationRate(int delegationRate) {
        this.delegationRate = delegationRate;
    }

    public void setDelegators(List<JsonDelegator> delegators) {
        this.delegators = delegators;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    @JsonIgnore
    public void setStakedAmount(BigInteger stakedAmount) {
        this.stakedAmount = stakedAmount;
    }

    public JsonBid(URef bondingPurse, int delegationRate, List<JsonDelegator> delegators, boolean inactive, BigInteger stakedAmount) {
        this.bondingPurse = bondingPurse;
        this.delegationRate = delegationRate;
        this.delegators = delegators;
        this.inactive = inactive;
        this.stakedAmount = stakedAmount;
    }

    public JsonBid() {
    }

    public static class JsonBidBuilder {
        private URef bondingPurse;
        private int delegationRate;
        private List<JsonDelegator> delegators;
        private boolean inactive;
        private BigInteger stakedAmount;

        JsonBidBuilder() {
        }

        @JsonProperty(value="bonding_purse")
        public JsonBidBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        @JsonProperty(value="delegation_rate")
        public JsonBidBuilder delegationRate(int delegationRate) {
            this.delegationRate = delegationRate;
            return this;
        }

        public JsonBidBuilder delegators(List<JsonDelegator> delegators) {
            this.delegators = delegators;
            return this;
        }

        public JsonBidBuilder inactive(boolean inactive) {
            this.inactive = inactive;
            return this;
        }

        @JsonIgnore
        public JsonBidBuilder stakedAmount(BigInteger stakedAmount) {
            this.stakedAmount = stakedAmount;
            return this;
        }

        public JsonBid build() {
            return new JsonBid(this.bondingPurse, this.delegationRate, this.delegators, this.inactive, this.stakedAmount);
        }

        public String toString() {
            return "JsonBid.JsonBidBuilder(bondingPurse=" + this.bondingPurse + ", delegationRate=" + this.delegationRate + ", delegators=" + this.delegators + ", inactive=" + this.inactive + ", stakedAmount=" + this.stakedAmount + ")";
        }
    }
}

