/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.status;

import com.casper.sdk.exception.CasperInvalidStateException;
import com.casper.sdk.model.common.Digest;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ChainspecData {
    @JsonProperty(value="api_version")
    private String apiVersion;
    @JsonProperty(value="chainspec_bytes")
    private ChainspecBytes chainspec;

    public void saveChainspec(Path path) throws IOException {
        Files.write(path, this.chainspec.getChainspecBytes().getDigest(), new OpenOption[0]);
    }

    public String readChainspecBytesToString() {
        if (this.chainspec.getChainspecBytes() != null && this.chainspec.getChainspecBytes().getDigest() != null) {
            return new String(this.chainspec.getChainspecBytes().getDigest());
        }
        return null;
    }

    public void saveGenesisAccounts(Path path) throws IOException {
        if (this.chainspec.getGenesisAccountsBytes() == null || this.chainspec.getGenesisAccountsBytes().getDigest() == null) {
            throw new CasperInvalidStateException("Genesis accounts bytes not found");
        }
        Files.write(path, this.chainspec.getGenesisAccountsBytes().getDigest(), new OpenOption[0]);
    }

    public String readGenesisAccountsBytesToString() {
        if (this.chainspec.getGenesisAccountsBytes() != null && this.chainspec.getGenesisAccountsBytes().getDigest() != null) {
            return new String(this.chainspec.getGenesisAccountsBytes().getDigest());
        }
        throw new CasperInvalidStateException("Genesis accounts bytes not found");
    }

    public void saveGlobalState(Path path) throws IOException {
        if (this.chainspec.getGlobalStateBytes() == null || this.chainspec.getGlobalStateBytes().getDigest() == null) {
            throw new CasperInvalidStateException("Global state bytes not found");
        }
        Files.write(path, this.chainspec.getGlobalStateBytes().getDigest(), new OpenOption[0]);
    }

    public String readGlobalStateBytesToString() {
        if (this.chainspec.getGlobalStateBytes() != null && this.chainspec.getGlobalStateBytes().getDigest() != null) {
            return new String(this.chainspec.getGlobalStateBytes().getDigest());
        }
        throw new CasperInvalidStateException("Global state bytes not found");
    }

    public static ChainspecDataBuilder builder() {
        return new ChainspecDataBuilder();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ChainspecBytes getChainspec() {
        return this.chainspec;
    }

    @JsonProperty(value="api_version")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="chainspec_bytes")
    public void setChainspec(ChainspecBytes chainspec) {
        this.chainspec = chainspec;
    }

    public ChainspecData(String apiVersion, ChainspecBytes chainspec) {
        this.apiVersion = apiVersion;
        this.chainspec = chainspec;
    }

    public ChainspecData() {
    }

    public static class ChainspecDataBuilder {
        private String apiVersion;
        private ChainspecBytes chainspec;

        ChainspecDataBuilder() {
        }

        @JsonProperty(value="api_version")
        public ChainspecDataBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @JsonProperty(value="chainspec_bytes")
        public ChainspecDataBuilder chainspec(ChainspecBytes chainspec) {
            this.chainspec = chainspec;
            return this;
        }

        public ChainspecData build() {
            return new ChainspecData(this.apiVersion, this.chainspec);
        }

        public String toString() {
            return "ChainspecData.ChainspecDataBuilder(apiVersion=" + this.apiVersion + ", chainspec=" + this.chainspec + ")";
        }
    }

    public static class ChainspecBytes {
        @JsonProperty(value="chainspec_bytes")
        private Digest chainspecBytes;
        @JsonProperty(value="maybe_genesis_accounts_bytes")
        private Digest genesisAccountsBytes;
        @JsonProperty(value="maybe_global_state_bytes")
        private Digest globalStateBytes;

        public static ChainspecBytesBuilder builder() {
            return new ChainspecBytesBuilder();
        }

        public Digest getChainspecBytes() {
            return this.chainspecBytes;
        }

        public Digest getGenesisAccountsBytes() {
            return this.genesisAccountsBytes;
        }

        public Digest getGlobalStateBytes() {
            return this.globalStateBytes;
        }

        @JsonProperty(value="chainspec_bytes")
        public void setChainspecBytes(Digest chainspecBytes) {
            this.chainspecBytes = chainspecBytes;
        }

        @JsonProperty(value="maybe_genesis_accounts_bytes")
        public void setGenesisAccountsBytes(Digest genesisAccountsBytes) {
            this.genesisAccountsBytes = genesisAccountsBytes;
        }

        @JsonProperty(value="maybe_global_state_bytes")
        public void setGlobalStateBytes(Digest globalStateBytes) {
            this.globalStateBytes = globalStateBytes;
        }

        public ChainspecBytes(Digest chainspecBytes, Digest genesisAccountsBytes, Digest globalStateBytes) {
            this.chainspecBytes = chainspecBytes;
            this.genesisAccountsBytes = genesisAccountsBytes;
            this.globalStateBytes = globalStateBytes;
        }

        public ChainspecBytes() {
        }

        public static class ChainspecBytesBuilder {
            private Digest chainspecBytes;
            private Digest genesisAccountsBytes;
            private Digest globalStateBytes;

            ChainspecBytesBuilder() {
            }

            @JsonProperty(value="chainspec_bytes")
            public ChainspecBytesBuilder chainspecBytes(Digest chainspecBytes) {
                this.chainspecBytes = chainspecBytes;
                return this;
            }

            @JsonProperty(value="maybe_genesis_accounts_bytes")
            public ChainspecBytesBuilder genesisAccountsBytes(Digest genesisAccountsBytes) {
                this.genesisAccountsBytes = genesisAccountsBytes;
                return this;
            }

            @JsonProperty(value="maybe_global_state_bytes")
            public ChainspecBytesBuilder globalStateBytes(Digest globalStateBytes) {
                this.globalStateBytes = globalStateBytes;
                return this;
            }

            public ChainspecBytes build() {
                return new ChainspecBytes(this.chainspecBytes, this.genesisAccountsBytes, this.globalStateBytes);
            }

            public String toString() {
                return "ChainspecData.ChainspecBytes.ChainspecBytesBuilder(chainspecBytes=" + this.chainspecBytes + ", genesisAccountsBytes=" + this.genesisAccountsBytes + ", globalStateBytes=" + this.globalStateBytes + ")";
            }
        }
    }
}

